/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
 *
 */

//#include <stdlib.h>

#include "utils.h"

#include <Qt>
#include "eWallet.h"
#include "Constants.h"
#include "DetailedWindow.h"
#include "QLabelImage.h"

#ifdef Q_WS_MAEMO_5
#include <QDBusInterface>
#include <QDBusConnection>
#endif
#include <QDesktopServices>

QLabelImage::QLabelImage(QWidget *parent, Qt::WindowFlags f): QLabel (parent, f) {
	image = NULL;

	setScaledContents(true);
	setContextMenuPolicy(Qt::CustomContextMenu);
	setBackgroundRole(QPalette::NoRole);
	setContentsMargins(5, 2, 0, 2);

#ifndef OPEN_SOURCE_VERSION
	QObject::connect(this, SIGNAL(clicked ()), this, SLOT(seePicture()));
#endif
}

void QLabelImage::mouseDoubleClickEvent(QMouseEvent * ev) {
	ev->accept();
   	emit clicked ();
}

void QLabelImage::seePicture() {
	if (viewerWindow.isNull() && image != NULL) {
		viewerWindow = new ImageViewer(new QImage (*image), this);
		viewerWindow->setAttribute(Qt::WA_DeleteOnClose);
        connect(viewerWindow, SIGNAL(destroyed(QObject*)), this, SLOT(windowViewerDestroyed(QObject*)));
        viewerWindow->show();
	}
}

void QLabelImage::windowViewerDestroyed (QObject*) {

}

QLabelImage::~QLabelImage() {

}

void QLabelImage::setPicture (QImage * i) {
	image = i;

	if (image != NULL) {
		this->setPixmap(QPixmap::fromImage (*image));
	}
}

void QLabelImage::setPicture (TargetField * field) {
	//TargetField * f = ((ButtonInfo *)this->userData(0))->field;

	//image = NULL;
	if (field->value.length() > 0) {
		image = new QImage ();

		qDebug () << "exist image " << field->value.length() << " bytes";
		//QByteArray im_s;
		//decrypt(query.value(0).toByteArray(), im_s);
		if (!image->loadFromData (QByteArray::fromBase64(field->value.toAscii()))) {

		}
	}

	if (image == NULL) {
		QPixmap available(":/resources/empty_field_image.png");
		this->setPixmap(available);
	}
	else {
		this->setPixmap(QPixmap::fromImage (*image));
	}
}

QImage * QLabelImage::getImage () {
	return image;
}

//QLabelImage::QLabelImage(QWidget *parent, Qt::WindowFlags f): QWidget (parent, f) {
//	layout = new QVBoxLayout;
//	label = new QLabel;
//	label->setScaledContents(true);
//	layout->addWidget(label);
//	setLayout(layout);
//	setContextMenuPolicy(Qt::CustomContextMenu);
//	setBackgroundRole(QPalette::NoRole);
//	setContentsMargins(5, 2, 0, 2);
//
//	mode = false;
//
//	tickTimer = 0;
//}
//
//void QLabelImage::setPixmap (const QPixmap & img) {
//	label->setPixmap (img);
//
//	factor = 1.0;
//	recalculate ();
//	label->resize(label->pixmap()->size() * factor);
//}
//
//void QLabelImage::mouseDoubleClickEvent(QMouseEvent * ev) {
//	qDebug () << "QLabelImage click " << mode;
//	ev->accept();
//   	//emit clicked ();
//	if (mode) {
//		layout->removeWidget(entryScrollArea);
//		layout->addWidget(label);
//		//label->setScaledContents(true);
//		setContextMenuPolicy(Qt::CustomContextMenu);
//		factor = 1.0;
//		recalculate ();
//		label->resize(label->pixmap()->size() * factor);
//	}
//	else {
//		entryScrollArea = new QScrollArea;
//		entryScrollArea->setProperty("FingerScrollable", true);
//		entryScrollArea->setWidget(label);
//		layout->addWidget(entryScrollArea);
//		recalculate ();
//		label->resize(label->pixmap()->size() * factor);
//		this->setContextMenuPolicy(Qt::NoContextMenu);
//	}
//	//setBackgroundRole(QPalette::NoRole);
//	//setContentsMargins(5, 2, 0, 2);
//	mode = !mode;
//}
//
//QLabelImage::~QLabelImage() {
//	if (tickTimer != 0) {
//		this->killTimer(tickTimer);
//		tickTimer = 0;
//	}
//
//}
////void QLabelImage::orientationChanged(int o) {
////
////}
//
//void QLabelImage::mousePressEvent(QMouseEvent * ev) {
//	//qDebug () << "mousePressEvent";
//	if (mode) {
//		ev->accept();
//		if (tickTimer == 0) {
//			tick = 0;
//			tickTimer = this->startTimer(100);
//		}
//	}
////	else
////		QWidget::event(ev);
//}
//
//void QLabelImage::mouseReleaseEvent(QMouseEvent * ev) {
//	//qDebug () << "mouseReleaseEvent";
//	if (mode) {
//		ev->accept();
//		if (tickTimer != 0) {
//			this->killTimer(tickTimer);
//			tickTimer = 0;
//		}
////	if (tick <= 10) {
//	}
////	else
////		QWidget::event(ev);
//}
//
//void QLabelImage::timerEvent(QTimerEvent *ev) {
//	if (tickTimer == ev->timerId()) {
//		tick++;
//		if (tick > 5) {
//			factor *= 1.03;
//			label->resize(label->pixmap()->size() * factor);
//		}
//	}
//}


