/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef IMAGEVIEWER_H
#define IMAGEVIEWER_H

#include <QtGui>
#include <QDebug>

class ImageViewer: public QMainWindow
{
	Q_OBJECT

public:
	ImageViewer (QImage * image, QWidget * parent = 0);
	~ImageViewer ();

private slots:
	void orientationChanged(int o);

protected:
    void timerEvent(QTimerEvent *event);
    //bool event(QEvent *event);
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);
    void mouseDoubleClickEvent ( QMouseEvent * event );

private:
	QImage * currentImage;
	int tickTimer;
	QLabel * centralWidget;
	QScrollArea * entryScrollArea;
	double factor;
	int tick;
    QMargins defaultMargins;
	void recalculate ();
	QPoint position;

public Q_SLOTS:
    void toggleFullScreen();

protected:
    void changeEvent(QEvent *event);

};


#endif // IMAGEVIEWER_H

#ifndef FULLSCREENEXITBUTTON_H
#define FULLSCREENEXITBUTTON_H

#include <QtGui/qtoolbutton.h>
#include <QtGui/qevent.h>

class FullScreenExitButton : public QToolButton
{
    Q_OBJECT
public:
    inline explicit FullScreenExitButton(QWidget *parent);

protected:
    inline bool eventFilter(QObject *obj, QEvent *ev);
};

FullScreenExitButton::FullScreenExitButton(QWidget *parent)
        : QToolButton(parent)
{
    Q_ASSERT(parent);

    // set the fullsize icon from Maemo's theme
    setIcon(QIcon::fromTheme(QLatin1String("general_fullsize")));

    // ensure that our size is fixed to our ideal size
    setFixedSize(sizeHint());

    // set the background to 0.5 alpha
    QPalette pal = palette();
    QColor backgroundColor = pal.color(backgroundRole());
    backgroundColor.setAlpha(128);
    pal.setColor(backgroundRole(), backgroundColor);
    setPalette(pal);

    // ensure that we're painting our background
    setAutoFillBackground(true);

    // when we're clicked, tell the parent to exit fullscreen
    connect(this, SIGNAL(clicked()), parent, SLOT(showNormal()));

    // install an event filter to listen for the parent's events
    parent->installEventFilter(this);
}

bool FullScreenExitButton::eventFilter(QObject *obj, QEvent *ev)
{
    if (obj != parent())
        return QToolButton::eventFilter(obj, ev);

    QWidget *parent = parentWidget();
    bool isFullScreen = parent->windowState() & Qt::WindowFullScreen;

    switch (ev->type()) {
    case QEvent::WindowStateChange:
        setVisible(isFullScreen);
        if (isFullScreen)
            raise();
        // fall through
    case QEvent::Resize:
        if (isVisible())
            move(parent->width() - width(),
                 parent->height() - height());
        break;
    default:
        break;
    }

    return QToolButton::eventFilter(obj, ev);
}

#endif
