/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef DETAIL_H
#define DETAIL_H

#include <QtGui>
#include <QDebug>
#include "DatabaseManager.h"

class eWallet;
class DetailWindow;

class CreateFieldDialog: public QDialog
{
	Q_OBJECT

public:
	CreateFieldDialog(Target * target, DetailWindow *paTarget );
	~CreateFieldDialog();

public slots:
	void previous();
	void next();
	void addNew();
	void save();
	void deleteCurrent();
	//void orientationChanged(int o);

private:
	void showField();
	void update();

	int pos;
	Target * target;
	DetailWindow * parent;
	QLineEdit * nameLineEdit;
	QLineEdit * orderEdit;
	QComboBox * typeLineEdit;
	QPushButton * previousButton;
	QPushButton * nextButton;
	QPushButton * deleteButton;
	QList<TargetField*> fields;
	bool _fieldsChanged;
};


class DetailWindow: public QMainWindow
{
	Q_OBJECT

public:
	DetailWindow (Target * target, const QString & groupName, int istemplate, bool edit, eWallet *paTarget, QWidget *parent = 0);
	~DetailWindow ();
	
	void addField (TargetField * field);
	static void loadImage (QString q, QImage& res);

private:
	int pos;
	int elType;
	eWallet * parent;
	
	QLabel * imageLabel;
	QLabel * imageBackLabel;
	Target * target;
	QWidget * centralWidget;
	QVBoxLayout * vboxlayout;
	QScrollArea * entryScrollArea;

	QLineEdit * nameLineEdit;
	QLineEdit * groupLineEdit;
	QComboBox * typeLineEdit;
	QList<QLineEdit*> labels;
	QList<QWidget*> values;

	QPointer <QMessageBox> messageBox;

	QImage * currentImage;
	QImage * currentImageBack;
	QImage * currentImageN;
	QImage * currentImageBackN;

	QString orgType;

	void showFields ();
	void changeFields (int);
	void _addField (TargetField * field);

	void closeEvent(QCloseEvent *event);
	bool edit;
	bool deleteFace;
	bool deleteBack;
	bool isNew;
	bool typeChanged;
	bool forceClose;

	QGridLayout * componentLayout;
	QPointer<CreateFieldDialog> createFieldDlg;

public slots:
	void saveTarget();
	void _deleteTarget();
	void _editTarget();
	void _newTarget();

	void takePicture();
	void photoTake (QImage* image);


	void _newLikeTarget();
	void _duplicateTarget();

	void cardFace();
	void mirrorFace();

	void orientationChanged (int);

	void deleteCardFace();
	void exportCardFace();
	void cardBack();	
	void mirrorBack();
	void deleteCardBack();
	void exportCardBack();

	void cardMenu(const QPoint & pos);
	void labelMenu(const QPoint & pos);
//	void cardFaceMenu(const QPoint & pos);
//	void cardBackMenu(const QPoint & pos);
//	void contextMenuEvent (QContextMenuEvent * event);

	void emitCommitData (int);
	void clickPass (QWidget *);
	void modifyFields ();

signals:
	void newTarget();
	void editTarget(Target * source);
	void newLikeTarget(Target * source);
	void duplicateTarget(Target * source);
public:
	bool fieldsChanged;

	void forceclose ();

	QSettings settings;
};

class ButtonInfo: public QObjectUserData {
public:
	TargetField * field;

	ButtonInfo (TargetField * field) {
		this->field = field;
	}
};

class QLabelW: public QLabel {
	Q_OBJECT
public:
	QLabelW(const QString &text, bool isLabel, QWidget *parent=0, Qt::WindowFlags f=0);
	QLabelW(QWidget *parent=0, Qt::WindowFlags f=0);
	~QLabelW();
public slots:
	void m_copy ();
	void m_goto ();
	void m_sms ();
	void m_call ();
protected:
	bool isLabel;
    void mousePressEvent(QMouseEvent *);
};

#endif // DETAIL_H
