/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H


#include <QtGui>
#include <QFileDialog>

class eWallet;
class AboutDialog;

class QLabelZ: public QLabel {
	Q_OBJECT
public:
	QLabelZ(const QString &text, QWidget *parent, Qt::WindowFlags f);
	QLabelZ(QWidget *parent, Qt::WindowFlags f);
	~QLabelZ();
	void paintEvent(QPaintEvent* event);
signals:
	void clicked ();

protected:
    void mousePressEvent(QMouseEvent *ev);
    void mouseReleaseEvent(QMouseEvent *ev);
private:
    bool select;
};

class LoginDialog : public QWidget
{
	Q_OBJECT

public:
	LoginDialog(bool firstTime, eWallet * paTarget);
	~LoginDialog();

	void resetF ();
	void keyPressEvent(QKeyEvent* event);
#ifdef Q_WS_MAEMO_5
	void orientationChanged(int o);
#endif
	void focus ();

private slots:
	void select(const QString& a);
	void acceptS();
	void clearS();
	void about();
	void donate();

private:
	QPointer<AboutDialog> aboutDialogDlg;
	QPointer <QMessageBox> messageBox;
	//void focusOutEvent ( QFocusEvent * event );
	//QString current;
	//QString repeat;
	eWallet * parent;
	QDialogButtonBox* dlgBtnBox;
	int NTimes;
	bool isFirstTime;
	QString newPassword;
//	QPushButton * imageButton [12];
	QLabelZ * imageButton [12];
	QLineEdit * label;
	QGridLayout * componentLayout;
};
#endif // LOGINDIALOG_H
