/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
// TODO several files? or several wallets in database?
// TODO export to a file with pictures!!!??
// TODO import picture from camera
// TODO modify picture (zoom, ...)
// TODO support for portrain
// TODO final images
 * TODO strong encryption with characters
 * TODO ask for second password when creating a db
 * TODO check that export images get the right size
 * TODO image size when no credit card (axa)
 * TODO free list resources
 * TODO after change type it is not refreshed on list
 * TODO implements URL to click on
 * TODO implements copy of information field (and images?)
 */

#include "eWallet.h"
#include "Constants.h"
#include "DatabaseManager.h"
#include <Qt>
#include <QFile>
#include <QDBusInterface>
#include <QDBusConnection>
#include <QDesktopServices>
//#ifdef Q_WS_MAEMO_5
//#include <mce/mode-names.h>
//#include <mce/dbus-names.h>
//#endif

DatabaseManager * dbManager;

eWallet::eWallet(QWidget *parent) :
		QMainWindow(parent)
{
	ascSort = true;
	currentFilter = "";
	currentTarget = NULL;

//qDBusRegisterMetaType<Property>();
//qDBusRegisterMetaType< QList<Property> >();
	loadTypesAndFields ();

	::dbManager = new DatabaseManager(this);

	askPassword ();

//	QDBusInterface *interface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
//                                   MCE_REQUEST_IF, QDBusConnection::systemBus(),
//                                   this);
//
//    QDBusMessage reply = interface->call(MCE_DISPLAY_SIG);
//    if (reply.type() == QDBusMessage::ErrorMessage)
//        qDebug() << "error? " << reply.errorMessage();

	QDBusConnection conn = QDBusConnection::systemBus(); //QString(MCE_SERVICE), QString(MCE_SIGNAL_PATH)
	bool success = conn.connect("","", QString("com.nokia.mce.signal"/*MCE_SIGNAL_IF*/), QString("display_status_ind"/*MCE_DISPLAY_SIG*/) , this, SLOT(listenInactivity(QString)));
//	bool success = conn.connect(QString(MCE_SERVICE), QString(MCE_SIGNAL_PATH), QString(MCE_SIGNAL_IF), QString(MCE_DISPLAY_SIG) /*MCE_DISPLAY_SIG MCE_DEVLOCK_MODE_GET MCE_DISPLAY_STATUS_GET MCE_INACTIVITY_STATUS_GET*/, this, SLOT(listenInactivity(QString)));
//	//bool success = conn.connect("com.nokia.mce","/com/nokia/mce/signal","com.nokia.mce.signal", MCE_TKLOCK_MODE_GET, this, SLOT(listenInactivity(string)));

	qDebug() << "SUCCESS : " << success;

	//timer = new QTimer(this);
	//connect(timer, SIGNAL(timeout()), this, SLOT(lockWallet()));
	//timer->start(5000);
	//showList  ();
}

void eWallet::showList () {
	setProperty("FingerScrollable", false);
	//setContextMenuPolicy(Qt::NoContextMenu);
	//                         // Central widget and Layout
	centralWidget = new QWidget(this);

	setContextMenuPolicy(Qt::DefaultContextMenu);
	centralWidget->setContextMenuPolicy(Qt::DefaultContextMenu);

	vboxlayout = new QVBoxLayout;
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);
	// Custom list box
	fnListWidget = new QFNListWidget(this);
	vboxlayout->addWidget(fnListWidget);

	inputWidget = new QHBoxLayout;
	inputWidget->setContentsMargins(2, 2, 2, 0);
	vboxlayout->addLayout(inputWidget);

	cancelSearch = new QPushButton(QIcon(":/resources/icon_clear.png"), "", this);
	searchField = new QLineEdit ();
	hideSearch = new QPushButton(QIcon(":/resources/icon_hide.png"), "", this);

	inputWidget->addWidget(cancelSearch);
	inputWidget->addWidget(searchField);
	inputWidget->addWidget(hideSearch);

	QObject::connect(cancelSearch, SIGNAL(clicked()), this, SLOT(_cancelSearch()));
	QObject::connect(hideSearch, SIGNAL(clicked()), this, SLOT(_hideSearch()));
	QObject::connect(searchField, SIGNAL(textChanged(const QString &)), this, SLOT(textChanged(const QString &)));

	cancelSearch->hide ();
	searchField->hide ();
	hideSearch->hide ();

	showTargets (true);

	centralWidget->setLayout(vboxlayout);
	setCentralWidget(centralWidget);

	createMenu ();

	centralWidget->setFocus ();
}

void eWallet::listenInactivity(QString s) {
	//qDebug () << "HELLO " << s;
	if (s == QString("off") && ::dbManager->isReady ()) {
		::dbManager->lock ();

		// TODO sure????
		fnListWidget->clear();
		list.clear ();

		if (!detailWindow.isNull()) {
			detailWindow->close();
			delete detailWindow;
			detailWindow = 0;
	    }

	    if (!detailWindowEdit.isNull()) {
			detailWindowEdit->close();
			delete detailWindowEdit;
			detailWindowEdit = 0;
	    }

	}
	else {
		if (s == QString("on") && !::dbManager->isReady ()) {
			askPassword ();
//			if (::dbManager->isReady ()) {
//				showList ();
//			}
		}
	}
}

void eWallet::textChanged (const QString & text) {
	currentFilter = text;
	filterBy (text);
}

void eWallet::filterBy (const QString & s) {
	fnListWidget->filterBy (s);
}

void eWallet::_cancelSearch () {
	searchField->setText("");
	searchField->hide();
	cancelSearch->hide();
	hideSearch->hide ();
}

void eWallet::_hideSearch () {
	searchField->hide();
	cancelSearch->hide();
	hideSearch->hide ();
}

void eWallet::lockWallet () {
	::dbManager->lock ();
	askPassword ();
}

bool eWallet::openDataBase (QString pas)
{
	bool res = ::dbManager->openDB(pas);

	if (!res) {
		if (++times > 3) {
			exit(3);
		}
		else {
			if (!::dbManager->isReady ()) {
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet", "Wrong password", QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;
			}
		}
	}
	else {
		showList ();
	}
	return res;
}

eWallet::~eWallet ()
{
	delete ::dbManager;
}
/*
 * TYPES
 * 	S -> String
 * 	T -> Text
 * 	D -> Date
 *  U -> URL
 *  P -> Password
 *  N -> Number
 *  H -> Phone number
 */
void eWallet::loadTypesAndFields () {
	  QFile file(":/resources/types.txt");
	  QString line;

	  if ( file.open(QIODevice::Text | QIODevice::ReadOnly) ) {
	    // file opened successfully
	    QTextStream t(&file);        // use a text stream
	    // until end of file...
	    int i = 0;
	    while ( !t.atEnd() ) {
	      // read and parse the command line
	      QString line = t.readLine();         // line of text excluding '\n'
	      // do something with the line

	      if (line.length() > 0) {
	    	  if ((i++) == 0) {
	    		  int p = line.indexOf(';');
	    		  if (p >= 0) {
	    			  // TODO
	    			  QChar imageType = line.at(p + 1);
					  this->types.append(line.mid(0, p).trimmed());
	    		  }
	    		  else {
					  this->types.append(line);
	    		  }
	    		  this->fieldsByType.append (new QList<TargetField>);
				  //qDebug () << " new type "<< line << " " << this->types.length();
	    	  }
	    	  else {
	    		  int p = line.indexOf(';');
	    		  if (p >= 0) {
	    			  int type = TYPE_STRING;
	    			  switch (line.at(p + 1).toAscii()) {
						  case 'T':
							  type = TYPE_TEXT;
							  break;
						  case 'D':
							  type = TYPE_DATE;
							  break;
						  case 'U':
							  type = TYPE_URL;
							  break;
						  case 'P':
							  type = TYPE_PASSWORD;
							  break;
						  case 'N':
							  type = TYPE_INTEGER;
							  break;
						  case 'H':
							  type = TYPE_PHONE_NUMBER;
							  break;
						  case 'S':
						  default:
			    			  type = TYPE_STRING;
						}
	    			  this->fieldsByType [this->types.length() - 1]->append(TargetField (line.mid(0, p).trimmed(), type, true, i));
	    		  }
	    		  else {
	    			  this->fieldsByType [this->types.length() - 1]->append(TargetField (line, TYPE_STRING, true, i));
	    		  }
				  //qDebug () << " new field "<< line << " " << this->types.length();
	    	  }
	      }
	      else {
	    	  i = 0;
	      }

	    }

	    // Close the file
	    file.close();
	  }
}

void eWallet::timerEvent(QTimerEvent* event) {

}
void eWallet::keyPressEvent(QKeyEvent* event) {
	//qDebug()<<"key pressed " << event->key();
	
	if (searchField->isHidden()) {
		cancelSearch->show ();
		searchField->show ();
		hideSearch->show ();
		searchField->setFocus();

		QCoreApplication::sendEvent (searchField, event);

		event->accept();
	}
	//timer->stop();
	//timer->start(5000);
}

bool sortTargetsASC (const Target * f, const Target * g) {
	return f->name.toLower() < g->name.toLower();
}
bool sortTargetsDES (const Target * f, const Target * g) {
	return f->name.toLower() > g->name.toLower();
}

void eWallet::showTargets(bool reset)
{
	// Clean previous items from the layout
	fnListWidget->clear();

	//QPixmap available(":/resources/icon_available.png");
	//QPixmap notavailable(":/resources/icon_notavailable.png");
	if (reset) {
		list.clear ();
		list = ::dbManager->getTargets ("");
	}

	if (ascSort)
		qSort (list.begin(),list.end(),sortTargetsASC);
	else
		qSort (list.begin(),list.end(),sortTargetsDES);

	for (int i = 0; i < list.size (); i++) {
		QFNListItem* listitem = new QFNListItem(list.at(i), this);
		fnListWidget->addItem(listitem, Qt::AlignTop | Qt::AlignLeft);
		
		QObject::connect(listitem, SIGNAL(viewTarget(Target*)),
                      this, SLOT(viewTarget(Target*)));
		QObject::connect(listitem, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		QObject::connect(listitem, SIGNAL(deleteTarget(Target*)),
                      this, SLOT(deleteTarget(Target*)));
	}

	filterBy(currentFilter);

	update();
}

void eWallet::createMenu()
{
	menuBar()->addAction("New", this, SLOT(newTarget()));
	menuBar()->addAction("Invert Sort", this, SLOT(sort()));
	menuBar()->addAction("Import", this, SLOT(import()));
	menuBar()->addAction("Export", this, SLOT(exportData()));
	menuBar()->addAction("About", this, SLOT(about()));
	menuBar()->addAction("Exit", QApplication::instance(), SLOT(quit()));

}

void eWallet::sort()
{
	ascSort = !ascSort;
	showTargets(false);
}

bool eWallet::_insertTarget(Target* target)
{
	if (::dbManager->insertTarget(target)) {
		//qDebug () << "Adding new item";
		::dbManager->updateFields (target);
		
		target->freeFieldList();

		QFNListItem* listitem = new QFNListItem(target, this);
		//qDebug () << "Adding new item 2";
		fnListWidget->addItem(listitem, Qt::AlignTop | Qt::AlignLeft);
		
		QObject::connect(listitem, SIGNAL(viewTarget(Target*)),
                      this, SLOT(viewTarget(Target*)));
		QObject::connect(listitem, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		QObject::connect(listitem, SIGNAL(deleteTarget(Target*)),
                      this, SLOT(deleteTarget(Target*)));
					  
		update ();
//qDebug () << "Adding new item 4";
		return true;
	}
	return false;
}
bool eWallet::_deleteTarget(Target* target)
{
	if (::dbManager->deleteTarget(target)) {
		QFNListItem* listitem = fnListWidget->itemAt (row);
//		//disconnect(obj, SIGNAL(destroyed(QObject*)),               this, SLOT(windowDestroyed(QObject*)));
//		QObject::disconnect(listitem, SIGNAL(viewTarget(Target*)),
//                      this, SLOT(viewTarget(Target*)));
//		QObject::disconnect(listitem, SIGNAL(editTarget(Target*)),
//                      this, SLOT(editTarget(Target*)));
//		QObject::disconnect(listitem, SIGNAL(deleteTarget(Target*)),
//                      this, SLOT(deleteTarget(Target*)));

		fnListWidget->removeItem (row);
		currentTarget = NULL;
//		target->freeFieldList();
//		target->freeResources();
//		delete target;
		// TODO delete listitem;
		update ();
		return true;
	}
	return false;
}
bool eWallet::_updateTarget(Target* target)
{
	if (::dbManager->updateTarget(target)) {
		::dbManager->updateFields (target);
		
		target->freeFieldList();

		if (row >= 0) {
			fnListWidget->itemAt (row)->setText (target->name);
		}			
		return true;
	}
	return false;
}

bool eWallet::_updateTargetPicture(Target* target)
{
	if (::dbManager->updateTargetPicture(target)) {
		if (row >= 0) {
			fnListWidget->itemAt (row)->setImage (target->getPictureSmall(), target->type);
		}
		return true;
	}
	return false;
}
bool eWallet::_updateTargetPictureBack(Target* target)
{
	if (::dbManager->updateTargetPictureBack(target)) {
		return true;
	}
	return false;
}

void eWallet::deleteTarget(Target * target) {

	//qDebug()<<"delete ";

	row = fnListWidget->findRow(target);
	
	currentTarget = target;

	_deleteTarget (target);

	delete target;
}

void eWallet::windowDestroyed(QObject* obj)
{
    disconnect(obj, SIGNAL(destroyed(QObject*)),
               this, SLOT(windowDestroyed(QObject*)));

//    if (currentTarget != NULL) {
//    	currentTarget->freeFieldList();
//    }

    if (obj == detailWindow.data()) {
		delete detailWindow;
		detailWindow = 0;
    }
    else
    if (obj == detailWindowEdit.data()) {
		delete detailWindowEdit;
		detailWindowEdit = 0;
    }
}

void eWallet::viewTarget(Target * rent) {
	//qDebug()<<"view ";

	row = fnListWidget->findRow(rent);

	currentTarget = rent;

	dbManager->getFields(rent);

	if (detailWindow.isNull()) {
		detailWindow = new DetailWindow(rent, false, this, this);

		connect(detailWindow, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		connect(detailWindow, SIGNAL(newTarget()),
                      this, SLOT(newTarget()));
#ifdef Q_WS_MAEMO_5
		detailWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
        detailWindow->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindow, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
	    detailWindow->show(); //owMaximized();
	}
}

void eWallet::editTarget(Target * rent) {
	//qDebug()<<"edit ";

	row = fnListWidget->findRow(rent);

	currentTarget = rent;

	dbManager->getFields(rent);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(rent, true, this, this);
#ifdef Q_WS_MAEMO_5
		detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
		detailWindowEdit->showMaximized();
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
        detailWindowEdit->show();
		//detailWindow->exec();
	}
}

void eWallet::import() {
	QString path(QDesktopServices::storageLocation(QDesktopServices::HomeLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose import file",
	                path,
	                "Text (*.txt)");
	if (!s.isNull () && !s.isEmpty ()) {

		  QFile file(s);
		  QString line;

		  Target * target = NULL;
		  if ( file.open(QIODevice::Text | QIODevice::ReadOnly) ) {
		    // file opened successfully
		    QTextStream t(&file);        // use a text stream
		    // until end of file...
		    int i = 0;
		    while ( !t.atEnd() ) {
		      // read and parse the command line
		      QString line = t.readLine();         // line of text excluding '\n'
		      // do something with the line

		      if (line.length() > 0) {
		    	  if (target == NULL) {
		    		  target = new Target ();
		    	  }

		    	  int j = line.indexOf(QChar(':'));
		    	  if (j > 0) {
					  switch (i++) {
					  case 0:
						  target->name = line.mid(j + 1).trimmed();
						  break;
					  case 1:
						  // TODO check type with existing one!
						  target->type = line.mid(j + 1).trimmed();
						  break;
					  default:
						  TargetField * field = new TargetField ();
						  field->name = line.mid (0, j).trimmed();
						  field->value = line.mid(j + 1).trimmed();
						  field->order = 10 * (i - 2);
						  field->encrypted = true;
						  if (field->name.contains("url", Qt::CaseInsensitive)) {
							  field->type = TYPE_URL;
						  }
						  else
						  if (field->name.contains("password", Qt::CaseInsensitive)) {
							  field->type = TYPE_PASSWORD;
						  }
						  else
						  if (field->name.contains("pin", Qt::CaseInsensitive)) {
							  field->type = TYPE_PASSWORD;
						  }
						  else
						  if (field->name.contains("phone", Qt::CaseInsensitive)) {
							  field->type = TYPE_PHONE_NUMBER;
						  }
						  else
						  if (field->name.contains("number", Qt::CaseInsensitive)) {
							  field->type = TYPE_INTEGER;
						  }
						  else
						  if (field->name.contains("date", Qt::CaseInsensitive)) {
							  field->type = TYPE_DATE;
						  }
						  else
						  if (field->name.contains("note", Qt::CaseInsensitive)) {
							  field->type = TYPE_TEXT;
						  }
						  else
							  field->type = TYPE_STRING;
						  target->fields.append(field);
					  }

					  qDebug () << line << " | " << line.mid(j + 1) << " IS " << line.mid (0, j);
		    	  }
		    	  else {
		    		  if (target != NULL && target->fields.size() > 0) {
		    			  target->fields.last()->value.append("\n").append (line);
		    			  target->fields.last()->type = TYPE_TEXT;
		    		  }
		    	  }
		      }
		      else {
		    	  if (target != NULL) {
		    		  this->_insertTarget(target);
		    	  }
		    	  target = NULL;
		    	  i = 0;
		      }

		      qDebug () << line;
		    }

			 if (target != NULL) {
				  this->_insertTarget(target);
			 }
		    // Close the file
		    file.close();
		  }

	}
}

void eWallet::newTarget() {
	//qDebug()<<"new ";

	row = -1;
	currentTarget = NULL;

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(NULL, true, this, this);
#ifdef Q_WS_MAEMO_5
		detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
		detailWindowEdit->showMaximized();
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
        detailWindowEdit->show();
		//detailWindow->exec();
	}
}
/*
void eWallet::contextMenuEvent (QContextMenuEvent * event) {
	//qDebug () << "Should be show " << this->childAt(event->globalPos());

	row = this->fnListWidget->findOn (event->globalPos());

	if (row >= 0) {
		QMenu menu(this);
		menu.addAction("View", this, SLOT(_viewcTarget()));
		menu.addAction("Edit", this, SLOT(_editcTarget()));
		menu.addAction("Delete", this, SLOT(_deletecTarget()));
		menu.exec(event->globalPos());
	}
}
*/
/*
void eWallet::editTarget(Target * rent)
{
	row = fnListWidget->findRow(rent);

	qDebug()<<"Edit ";

	if (createTargetDlg.isNull()) {
			createTargetDlg = new CreateTargetDialog(rent, this);
#if defined(Q_OS_WIN32)
			createTargetDlg->setFixedSize(640,480);
#elif defined(Q_WS_HILDON)
			createTargetDlg->setMinimumSize(size().width(),size().height()-100);
#else
			createTargetDlg->showMaximized();
#endif
			createTargetDlg->exec();
			delete createTargetDlg;
			createTargetDlg = 0;
		
	}
}
*/

void eWallet::exportData() {
	QString path(QDesktopServices::storageLocation(QDesktopServices::HomeLocation));
	QString s = QFileDialog::getSaveFileName(
	                this,
	                "Choose export file",
	                path,
	                "Text (*.txt)");
	if (!s.isNull () && !s.isEmpty ()) {
		  QFile file(s);

		  if ( file.open(QIODevice::Text | QIODevice::WriteOnly) ) {
		    // file opened successfully
		    QTextStream t(&file);        // use a text stream

			for (int i = 0; i < list.size (); i++) {
				Target * target = list[i];

				t << "Name: " << target->name << "\n";
				t << "Type: " << target->type << "\n";

				dbManager->getFields(target);

				TargetField * field;
				foreach(field, target->fields) {
					t << field->name << ": " << field->value << "\n";
				}

				t << "\n\n";

				target->freeFieldList();

			}

		    // Close the file
		    file.close();
		  }
	}
}
void eWallet::_editcTarget() {
	editTarget(this->fnListWidget->itemAt(row)->getSource());
}
void eWallet::_deletecTarget() {
	deleteTarget(this->fnListWidget->itemAt(row)->getSource());
}
void eWallet::_viewcTarget() {
	viewTarget(this->fnListWidget->itemAt(row)->getSource());
}

//eWallet closeEvent function:
void eWallet::closeEvent(QCloseEvent *event){
	//qDebug () << "close Event";
        //saveSettings();
        event->accept();
}

void eWallet::askPassword () {
	times = 0;
	
	menuBar()->clear();

//	do {
		if (loginDialogDlg.isNull()) {
			loginDialogDlg = new LoginDialog(this);
			setCentralWidget(loginDialogDlg);
			loginDialogDlg->setFocus ();
//	#if defined(Q_OS_WIN32)
//			loginDialogDlg->setFixedSize(640,480);
//	#elif defined(Q_WS_HILDON)
//			loginDialogDlg->setMinimumSize(size().width(),size().height()-100);
//	#else
//			loginDialogDlg->showMaximized();
//	#endif
//			loginDialogDlg->setFocus();
//			loginDialogDlg->exec();
//			delete loginDialogDlg;
//			loginDialogDlg = 0;
		}
		
		//qDebug () << "TIME " << times;
			
//		if (++times > 3) {
//			exit(3);
//		}
//		else {
//			if (!::dbManager->isReady ()) {
//				if (messageBox.isNull()) {
//					messageBox = new QMessageBox(this);
//					messageBox->information(this, "Wallet", "Wrong password", QMessageBox::Ok);
//				}
//				delete messageBox;
//				messageBox = 0;
//			}
//		}
//	}
//	while(!::dbManager->isReady ());
}

void eWallet::about() {
	QMessageBox::about(this, "About qtWallet", TEXT_ABOUT);
//	if (aboutDialogDlg.isNull()) {
//		aboutDialogDlg = new AboutDialog(this);
//		aboutDialogDlg->showMaximized();
//#ifdef Q_WS_MAEMO_5
//		aboutDialogDlg->setAttribute(Qt::WA_Maemo5StackedWindow);
//#endif
//		aboutDialogDlg->setAttribute(Qt::WA_DeleteOnClose);
//        //connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this, SLOT(windowDestroyed(QObject*)));
//        aboutDialogDlg->show();
//
//	}
}
//void AboutDialog::donate() {
//	QDesktopServices::openUrl( QUrl::fromEncoded("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtWallet&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted" ) );
//}
//AboutDialog::AboutDialog(QWidget *paTarget) : QMainWindow(paTarget)
//{
//	setContextMenuPolicy(Qt::NoContextMenu);
//
//	QWidget * centralWidget = new QWidget(this);
//	setCentralWidget(centralWidget);
//
//	QVBoxLayout * layout = new QVBoxLayout ();
//
//	QLabel * label;
//
//	label = new QLabel("<qt><br><br><p><i><b>qtWallet</b></i>, v.1.0</p>"
//			"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"
//			"<br>"
//			"<p>if you think that qtWallet is useful for you, please</p></qt>", this);
//	label->setContextMenuPolicy(Qt::NoContextMenu);
//	label->setAlignment(Qt::AlignCenter);
//	layout->addWidget(label);
//
//	QPushButton * donate = new QPushButton(QIcon(":/resources/donate.gif"), "DONATE", this);
//	donate->setMinimumHeight(100);
//	//donate->setIconSize(QSize(150,80));
//	//QHBoxLayout * lah = new QHBoxLayout ();
//	//lah->addWidget(donate);
//	layout->addWidget(donate);
//
//	QObject::connect(donate, SIGNAL(clicked()), this, SLOT(donate()));
//
////	label = new QLabel("<qt><a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtWallet&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted\">DONATE</a></qt>", this);
////	label->setContextMenuPolicy(Qt::NoContextMenu);
////	label->setOpenExternalLinks (true);
////	label->setAlignment(Qt::AlignCenter);
////	label->setMinimumHeight(100);
////
////	QPixmap available(":/resources/donate.gif");
////	label->setPixmap(available);
//
////	layout->addWidget(label);
//
//	centralWidget->setLayout(layout);
//}
//
//AboutDialog::~AboutDialog()
//{
//}

