/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "eWallet.h"
#include "LoginDialog.h"
#include "Constants.h"

LoginDialog::LoginDialog(eWallet *paTarget): QWidget((QWidget*)paTarget)
{
	setContextMenuPolicy(Qt::NoContextMenu);

	QHBoxLayout * layout = new QHBoxLayout(this);
	QGridLayout * componentLayout = new QGridLayout ();
	this->parent = paTarget;

	layout->setSpacing(0);
	layout->setMargin(10);

	componentLayout->setContentsMargins(20, 20, 20, 20);

	QPushButton * imageButton [12];

	QSignalMapper * signalMapper = new QSignalMapper(this);

	label = new QLabel("", this);
	label->setContextMenuPolicy(Qt::NoContextMenu);
	label->setAlignment(Qt::AlignCenter);

	
	for (int i = 0; i < 12; i++) {
		QString text ('0' + i + 1);

		if (i == 9) {
			text = "Ok";
			imageButton[i] = new QPushButton(text, this); // QIcon(":/resources/icon_accept.png"),
			imageButton[i] ->setFixedHeight(60);
			imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
			imageButton[i] ->setFocusPolicy(Qt::NoFocus);
			imageButton[i] ->setIconSize(QSize(20, 20));
			componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

			//signalMapper->setMapping(imageButton[i], text);

			QObject::connect(imageButton[i], SIGNAL(clicked()), this, SLOT(acceptS()));
		} else {
			if (i == 10) {
				text = "0";
				imageButton[i] = new QPushButton(text, this); // QIcon(":/resources/number.png"),
				imageButton[i] ->setFixedHeight(60);
				imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
				imageButton[i] ->setFocusPolicy(Qt::NoFocus);
				imageButton[i] ->setIconSize(QSize(20, 20));
				componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

				signalMapper->setMapping(imageButton[i], text);

				QObject::connect(imageButton[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
			} else
				if (i == 11) {
					text = "Clear";
					imageButton[i] = new QPushButton(text, this); // QIcon(":/resources/icon_clear.png"),
					imageButton[i] ->setFixedHeight(60);
					imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
					imageButton[i] ->setFocusPolicy(Qt::NoFocus);
					imageButton[i] ->setIconSize(QSize(20, 20));
					componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

					//signalMapper->setMapping(imageButton[i], text);

					QObject::connect(imageButton[i], SIGNAL(clicked()), this, SLOT(clearS()));
				} else {
					imageButton[i] = new QPushButton(text, this); // QIcon(":/resources/number.png"),
					imageButton[i] ->setFixedHeight(60);
					imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
					imageButton[i] ->setFocusPolicy(Qt::NoFocus);
					imageButton[i] ->setIconSize(QSize(20, 20));
					componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

					signalMapper->setMapping(imageButton[i], text);

					QObject::connect(imageButton[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
				}
		}
	}

	componentLayout->addItem(new QSpacerItem(2,3), 4, 3, 3, 2);

	connect(signalMapper, SIGNAL(mapped(const QString &)),
	        this, SLOT(select(const QString &)));

	componentLayout->addWidget(label, 4, 0, 1, 4);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	QPushButton * aboutButton = new QPushButton(QIcon(":/resources/about.png"), "About", this);
	aboutButton->setFixedHeight(70);
	aboutButton->setContextMenuPolicy(Qt::NoContextMenu);
	aboutButton->setFocusPolicy(Qt::NoFocus);
	aboutButton->setIconSize(QSize(48, 48));
	QObject::connect(aboutButton, SIGNAL(clicked()), this, SLOT(about()));
	dlgBtnBox->addButton(aboutButton, QDialogButtonBox::ActionRole);

	QPushButton * deleteButton = new QPushButton(QIcon(":/resources/exit.png"), "Exit", this);
	deleteButton->setFixedHeight(70);
	deleteButton->setContextMenuPolicy(Qt::NoContextMenu);
	deleteButton->setFocusPolicy(Qt::NoFocus);
	deleteButton->setIconSize(QSize(48, 48));
	QObject::connect(deleteButton, SIGNAL(clicked()), QApplication::instance(), SLOT(quit()));
	dlgBtnBox->addButton(deleteButton, QDialogButtonBox::ActionRole);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);


	setLayout(layout);
}

LoginDialog::~LoginDialog()
{
}
void LoginDialog::about()
{
    QMessageBox::about(this, "About qtWallet", TEXT_ABOUT);
//    if (aboutDialogDlg.isNull()) {
//		aboutDialogDlg = new AboutDialog(this);
//		aboutDialogDlg->showMaximized();
//#ifdef Q_WS_MAEMO_5
//		aboutDialogDlg->setAttribute(Qt::WA_Maemo5StackedWindow);
//#endif
//		aboutDialogDlg->setAttribute(Qt::WA_DeleteOnClose);
//        //connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this, SLOT(windowDestroyed(QObject*)));
//        aboutDialogDlg->show();
//	}
}
void LoginDialog::clearS()
{
	label->setText ("");
	current = "";
}

void LoginDialog::acceptS() {
	if (parent->openDataBase (current)) {
		//close();
	}
	else {

		label->setText ("");
		current = "";
	}
}

void LoginDialog::select(const QString& a) {
	if (current.size() < KEY_SIZE) {
		current += a;
		label->setText (QString ("************************").right(current.size()));		
	}
}

void LoginDialog::keyPressEvent(QKeyEvent* event) {
	//qDebug()<<"key pressed " << event->key();
	
	if (event->key() >= Qt::Key_0 && event->key() <= Qt::Key_9) {
		if (current.size() < KEY_SIZE) {
			current += (char)(event->key());
			label->setText (QString ("************************").right(current.size()));		
		}
		event->accept();
	}
	else {
		if (event->key() == Qt::Key_Backspace || event->key() == Qt::Key_Delete) {
			if (current.size () > 0) {
				current = current.left (current.size ()-1);
				label->setText (QString ("************************").right(current.size()));						
			}
			event->accept();
		}
		else {
			if (event->key() == Qt::Key_Return || event->key() == Qt::Key_Enter) {
				event->accept();
				acceptS();
			}
			else {
				event->accept();//QWidget::keyPressEvent(event);
			}
		}
	}
}
/*
void LoginDialog::focusOutEvent ( QFocusEvent * event ) {
	
	qDebug () << "LOST FOCUS";
}
*/
