/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "eWallet.h"
#include "DatabaseManager.h"
#include <Qt>
#ifdef Q_WS_MAEMO_5
//#include <QtMaemo5/QMaemo5KineticScroller>
#endif

DatabaseManager * dbManager;

eWallet::eWallet(QWidget *parent) :
		QMainWindow(parent)
{
	::dbManager = new DatabaseManager(this);

	do {
		if (loginDialogDlg.isNull()) {
			loginDialogDlg = new LoginDialog(this);
	#if defined(Q_OS_WIN32)
			loginDialogDlg->setFixedSize(640,480);
	#elif defined(Q_WS_HILDON)
			loginDialogDlg->setMinimumSize(size().width(),size().height()-100);
	#else
			loginDialogDlg->showMaximized();
	#endif
			loginDialogDlg->exec();
			delete loginDialogDlg;
			loginDialogDlg = 0;
		}
	}
	while(!::dbManager->isReady ());
	
	setProperty("FingerScrollable", false);
	//setContextMenuPolicy(Qt::NoContextMenu);

	this->types.append("Credit Card");
	this->types.append("ID");
	this->types.append("Others");

	fieldsByType [0].append(TargetField ("Expired Date", TYPE_DATE, true, 1));
	fieldsByType [0].append(TargetField ("Bank", TYPE_STRING, true, 2));
	fieldsByType [0].append(TargetField ("PIN", TYPE_INTEGER, true, 3));
	fieldsByType [0].append(TargetField ("Extra 1", TYPE_STRING, true, 40));
	fieldsByType [0].append(TargetField ("Extra 2", TYPE_STRING, true, 50));
	fieldsByType [0].append(TargetField ("Extra 3", TYPE_STRING, true, 60));
	fieldsByType [0].append(TargetField ("Extra 4", TYPE_STRING, true, 70));
	fieldsByType [0].append(TargetField ("Extra 5", TYPE_STRING, true, 80));

	fieldsByType [1].append(TargetField ("Issued Date", TYPE_DATE, true, 1));
	fieldsByType [1].append(TargetField ("Titular", TYPE_STRING, true, 2));
	fieldsByType [1].append(TargetField ("PIN", TYPE_INTEGER, true, 3));
	fieldsByType [1].append(TargetField ("Extra 1", TYPE_STRING, true, 40));
	fieldsByType [1].append(TargetField ("Extra 2", TYPE_STRING, true, 50));
	fieldsByType [1].append(TargetField ("Extra 3", TYPE_STRING, true, 60));
	fieldsByType [1].append(TargetField ("Extra 4", TYPE_STRING, true, 70));
	fieldsByType [1].append(TargetField ("Extra 5", TYPE_STRING, true, 80));

	fieldsByType [2].append(TargetField ("Extra 1", TYPE_STRING, true, 40));
	fieldsByType [2].append(TargetField ("Extra 2", TYPE_STRING, true, 50));
	fieldsByType [2].append(TargetField ("Extra 3", TYPE_STRING, true, 60));
	fieldsByType [2].append(TargetField ("Extra 4", TYPE_STRING, true, 70));
	fieldsByType [2].append(TargetField ("Extra 5", TYPE_STRING, true, 80));

	//                         // Central widget and Layout
	centralWidget = new QWidget(this);

	setContextMenuPolicy(Qt::DefaultContextMenu);
	centralWidget->setContextMenuPolicy(Qt::DefaultContextMenu);

	vboxlayout = new QVBoxLayout;
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);
	// Custom list box
	fnListWidget = new QFNListWidget(this);
	vboxlayout->addWidget(fnListWidget);

	showTargets ();

	centralWidget->setLayout(vboxlayout);
	setCentralWidget(centralWidget);

	createMenu ();

	centralWidget->setFocus ();
}

bool eWallet::openDataBase (QString pas)
{
	return ::dbManager->openDB(pas);
}

eWallet::~eWallet ()
{
	delete ::dbManager;
}



void eWallet::timerEvent(QTimerEvent* event)
{
}
void eWallet::keyPressEvent(QKeyEvent* event) {
	//qDebug()<<"key pressed " << event->key();


	
/*		if (event->key() == Qt::Key_Backspace || event->key() == Qt::Key_Delete) {
			if (current.size () > 0) {
				current = current.left (current.size ()-1);
				label->setText (QString ("************************").right(current.size()));						
			}
			event->accept();
		}
		else {
			if (event->key() == Qt::Key_Return || event->key() == Qt::Key_Enter) {
				event->accept();
				acceptS();
			}
			else {*/
				QWidget::keyPressEvent(event);
/*			}
		}
	}*/
}


void eWallet::showTargets()
{
	// Clean previous items from the layout
	fnListWidget->clear();

	//QPixmap available(":/resources/icon_available.png");
	//QPixmap notavailable(":/resources/icon_notavailable.png");

	list.clear ();
	list = ::dbManager->getTargets ("");

	for (int i = 0; i < list.size (); i++) {
		QFNListItem* listitem = new QFNListItem(list.at(i), this);
		fnListWidget->addItem(listitem, Qt::AlignTop | Qt::AlignLeft);
		
		QObject::connect(listitem, SIGNAL(viewTarget(Target*)),
                      this, SLOT(viewTarget(Target*)));
		QObject::connect(listitem, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		QObject::connect(listitem, SIGNAL(deleteTarget(Target*)),
                      this, SLOT(deleteTarget(Target*)));
	}
	//fnListWidget->setFocusedItem(0);
	update();
}

void eWallet::createMenu()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_HILDON)
	menuBar()->addAction("New", this, SLOT(newTarget()));
//	menuBar()->addAction("Edit", this, SLOT(editTarget()));
	menuBar()->addAction("Exit", QApplication::instance(), SLOT(quit()));
#else
	QMenu* optionsMenu = menuBar()->addMenu(tr("&File"));
	optionsMenu->addAction("New", this, SLOT(newTarget()));
	//optionsMenu->addAction("Edit", this, SLOT(editTarget()));
	optionsMenu->addAction("Exit", QApplication::instance(), SLOT(quit()));
#endif
}
/*
void eWallet::newTarget()
{
	row = -1;
	if (createTargetDlg.isNull()) {
		createTargetDlg = new CreateTargetDialog(NULL, this);
#if defined(Q_OS_WIN32)
		createTargetDlg->setFixedSize(640,480);
#elif defined(Q_WS_HILDON)
		createTargetDlg->setMinimumSize(size().width(),size().height()-100);
#else
		createTargetDlg->showMaximized();
#endif
		createTargetDlg->exec();
		delete createTargetDlg;
		createTargetDlg = 0;
	}
}
*/
bool eWallet::_insertTarget(Target* target)
{
	if (::dbManager->insertTarget(target)) {
		//qDebug () << "Adding new item";
		::dbManager->updateFields (target);
		
		QFNListItem* listitem = new QFNListItem(target, this);
		//qDebug () << "Adding new item 2";
		fnListWidget->addItem(listitem, Qt::AlignTop | Qt::AlignLeft);
		
		QObject::connect(listitem, SIGNAL(viewTarget(Target*)),
                      this, SLOT(viewTarget(Target*)));
		QObject::connect(listitem, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		QObject::connect(listitem, SIGNAL(deleteTarget(Target*)),
                      this, SLOT(deleteTarget(Target*)));
					  
		update ();
//qDebug () << "Adding new item 4";
		return true;
	}
	return false;
}
bool eWallet::_deleteTarget(Target* target)
{
	if (::dbManager->deleteTarget(target)) {
		QFNListItem* listitem = fnListWidget->itemAt (row);

		//disconnect(obj, SIGNAL(destroyed(QObject*)),               this, SLOT(windowDestroyed(QObject*)));
		QObject::disconnect(listitem, SIGNAL(viewTarget(Target*)),
                      this, SLOT(viewTarget(Target*)));
		QObject::disconnect(listitem, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		QObject::disconnect(listitem, SIGNAL(deleteTarget(Target*)),
                      this, SLOT(deleteTarget(Target*)));

		fnListWidget->removeItem (row);

		update ();
		return true;
	}
	return false;
}
bool eWallet::_updateTarget(Target* target)
{
	if (::dbManager->updateTarget(target)) {
		::dbManager->updateFields (target);
		
		if (row >= 0) {
			fnListWidget->itemAt (row)->setText (target->name);
		}			
		return true;
	}
	return false;
}

bool eWallet::_updateTargetPicture(Target* target)
{
	if (::dbManager->updateTargetPicture(target)) {
		if (row >= 0) {
			fnListWidget->itemAt (row)->setImage (target->picture);
		}
		return true;
	}
	return false;
}
bool eWallet::_updateTargetPictureBack(Target* target)
{
	if (::dbManager->updateTargetPictureBack(target)) {
		return true;
	}
	return false;
}

void eWallet::deleteTarget(Target * target) {

	qDebug()<<"delete ";

	row = fnListWidget->findRow(target);
	
	_deleteTarget (target);

	delete target;
}

void eWallet::windowDestroyed(QObject* obj)
{
    disconnect(obj, SIGNAL(destroyed(QObject*)),
               this, SLOT(windowDestroyed(QObject*)));

    if (obj == detailWindow.data()) {
		delete detailWindow;
		detailWindow = 0;
    }
    else
    if (obj == detailWindowEdit.data()) {
		delete detailWindowEdit;
		detailWindowEdit = 0;
    }
}

void eWallet::viewTarget(Target * rent) {
	qDebug()<<"view ";

	row = fnListWidget->findRow(rent);

	dbManager->getFields(rent);

	if (detailWindow.isNull()) {
		detailWindow = new DetailWindow(rent, false, this, this);

		connect(detailWindow, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		connect(detailWindow, SIGNAL(newTarget()),
                      this, SLOT(newTarget()));
#ifdef Q_WS_MAEMO_5
		detailWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
        detailWindow->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindow, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
	    detailWindow->show(); //owMaximized();
	}
}

void eWallet::editTarget(Target * rent) {
	qDebug()<<"edit ";

	row = fnListWidget->findRow(rent);

	dbManager->getFields(rent);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(rent, true, this, this);
#ifdef Q_WS_MAEMO_5
		detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
		detailWindowEdit->showMaximized();
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
        detailWindowEdit->show();
		//detailWindow->exec();
	}
}

void eWallet::newTarget() {
	qDebug()<<"new ";

	row = -1;

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(NULL, true, this, this);
#ifdef Q_WS_MAEMO_5
		detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
		detailWindowEdit->showMaximized();
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
        detailWindowEdit->show();
		//detailWindow->exec();
	}
}
/*
void eWallet::contextMenuEvent (QContextMenuEvent * event) {
	//qDebug () << "Should be show " << this->childAt(event->globalPos());

	row = this->fnListWidget->findOn (event->globalPos());

	if (row >= 0) {
		QMenu menu(this);
		menu.addAction("View", this, SLOT(_viewcTarget()));
		menu.addAction("Edit", this, SLOT(_editcTarget()));
		menu.addAction("Delete", this, SLOT(_deletecTarget()));
		menu.exec(event->globalPos());
	}
}
*/
/*
void eWallet::editTarget(Target * rent)
{
	row = fnListWidget->findRow(rent);

	qDebug()<<"Edit ";

	if (createTargetDlg.isNull()) {
			createTargetDlg = new CreateTargetDialog(rent, this);
#if defined(Q_OS_WIN32)
			createTargetDlg->setFixedSize(640,480);
#elif defined(Q_WS_HILDON)
			createTargetDlg->setMinimumSize(size().width(),size().height()-100);
#else
			createTargetDlg->showMaximized();
#endif
			createTargetDlg->exec();
			delete createTargetDlg;
			createTargetDlg = 0;
		
	}
}
*/
void eWallet::_editcTarget() {
	editTarget(this->fnListWidget->itemAt(row)->getSource());
}
void eWallet::_deletecTarget() {
	deleteTarget(this->fnListWidget->itemAt(row)->getSource());
}
void eWallet::_viewcTarget() {
	viewTarget(this->fnListWidget->itemAt(row)->getSource());
}

