/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */


#ifndef QFNLISTWIDGET_H
#define QFNLISTWIDGET_H

#include <QWidget>
#include <QVBoxLayout>
#include <QList>
#include <QScrollArea>
#include <QFrame>
#include <QListWidget>
#include <QMouseEvent>
#include "QFNListItem.h"

class QFNListWidget: public QWidget
{
	Q_OBJECT

public:
	QFNListWidget(QWidget* parent = 0);
	~QFNListWidget();

	//void mouseMoveEvent(QMouseEvent *event);
	//void resizeEvent(QResizeEvent *);
	//void timerEvent(QTimerEvent *);

	void addItem(QFNListItem* item, Qt::Alignment alignment = 0);
	void removeItem(int index);

	int findOn(const QPoint & p);

	void clear();

	int findRow(Target * t);
	void setFocusedItem(int index);
	QFNListItem* itemAt(int index);

	QList<QFNListItem*> itemList;

private:
	//void updatePos();

private:
	QVBoxLayout*    frameLayout;
	QFrame*         entryFrame;
	QScrollArea*    entryScrollArea;
	int             timerid;
	QFNListItem*    customFocusItem;
	
};

#endif // QFNLISTWIDGET_H
