/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef DETAIL_H
#define DETAIL_H

#include <QtGui>
#include <QDebug>
#include "DatabaseManager.h"

class eWallet;

class DetailWindow: public QMainWindow
{
	Q_OBJECT

public:
	DetailWindow (Target * target, bool edit, eWallet *paTarget, QWidget *parent = 0);
	~DetailWindow ();
	
private:
	eWallet * parent;
	
	QLabel * imageLabel;
	QLabel * imageBackLabel;
	Target * target;
	QWidget * centralWidget;
	QVBoxLayout * vboxlayout;
	QScrollArea * entryScrollArea;

	QLineEdit * nameLineEdit;
	QComboBox * typeLineEdit;
	QList<QLineEdit*> labels;
	QList<QLineEdit*> values;

	QPointer <QMessageBox> messageBox;

	QImage * currentImage;
	QImage * currentImageBack;
	QImage * currentImageN;
	QImage * currentImageBackN;

	void loadImage (QString q, QImage& res);
	void showFields ();
	void changeFields (int);

	bool edit;
	bool deleteFace;
	bool deleteBack;
	bool isNew;

	QGridLayout * componentLayout;

public slots:
	void saveTarget();
	void _deleteTarget();
	void _editTarget();
	void _newTarget();
	void cardFace();
	void cardMenu(const QPoint & pos);
	void deleteCardFace();
	void exportCardFace();
	void cardFaceMenu(const QPoint & pos);
	void cardBack();	
	void deleteCardBack();
	void exportCardBack();
	void cardBackMenu(const QPoint & pos);
	void emitCommitData (int);

signals:
	void newTarget();
	void editTarget(Target * source);

};
#endif // DETAIL_H
