/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef CREATETargetDIALOG_H
#define CREATETargetDIALOG_H

#include <QtGui>
#include <QtSql>
#include <QFileDialog>

class eWallet;
class DatabaseManager;
class Target;

class CreateTargetDialog: public QDialog
{
	Q_OBJECT

public:
	CreateTargetDialog(Target* target, eWallet *paTarget );
	~CreateTargetDialog();

public slots:
	void save();
	void deleteTarget();
	void cardFace();
	void cardBack();

private:
	void createMenu();
	void createButtons(QBoxLayout*);
	void loadImage (QString q, QImage& res);
	
private:

	QHBoxLayout* layout;



	Target* target;
	QImage * currentImage;
	QImage * currentImageBack;
	QImage * currentImageN;
	QImage * currentImageBackN;

	eWallet * parent;

	QLabel* nameLabel;
	QLineEdit* nameLineEdit;
	QLabel* imageLabel;
	QLabel* imageBackLabel;

	QLabel* typeLabel;
	QComboBox* typeLineEdit;

	QPushButton* saveButton;
	QPushButton* deleteButton;
	QPushButton* imageButton;
	QPushButton* imageBackButton;

	QMenuBar* menuBar;
	QMenu* menu;

	QDate date;

	QPointer <QMessageBox> messageBox;
};

#endif // CreateTargetDialog_H
