import Qt 4.7

Item {
	id: series

	signal clicked()

	x: 15
	width: listView.width - 30
	height: topLayout.height + 14

	Rectangle {
		color: "black"
		anchors.fill: parent
		radius: 4

		border.color: "gray"
		border.width: 2
		smooth: true
	}

	MouseArea {
		anchors.fill: parent
		onClicked: { series.clicked(); console.log("Item '" + name + "' clicked") }
	}

	Item {
		id: topLayout
		x: 20; width: parent.width; height: titleLabel.height
		anchors.verticalCenter: parent.verticalCenter

		Text {
			id: titleLabel
			text: name
			color: "white"

			font.pixelSize: 26
			font.bold: true;
			wrapMode: Text.WordWrap
		}
	}
}

