import Qt 4.7

Rectangle {
	SystemPalette { id: palette; colorGroup: SystemPalette.Active }
	id: searchBar
	height: 40

	border.color: palette.mid

	gradient: Gradient {
		GradientStop { id: gradientStop1; position: 0.0; color: Qt.lighter(palette.button) }
		GradientStop { id: gradientStop2; position: 1.0; color: palette.button }
	}

	signal search(string text);

	SearchBox{
		id: searchBox
		state: 'Show'
		height: parent.height - 10
		focus: parent.focus
		anchors.right: button.left
		anchors.rightMargin: 5
		anchors.left: parent.left
		anchors.leftMargin: 5
		anchors.verticalCenter: parent.verticalCenter

		onReturnPressed: {
			if (searchBox.text !== '') {
				searchBar.search(searchBox.text);
				searchBox.text = ""
			}
		}

		states: [
			State {
				name: "Hide"
				PropertyChanges {
					target: searchBox
					opacity: 0.0
				}
			},
			State {
				name: "Show"
				PropertyChanges {
					target: searchBox
					opacity: 1.0
				}
			}
		]
	}

	Button {
		id: button
		height: parent.height
		anchors.right: parent.right

		text: "Search"

		onClicked: {
			if (searchBox.text != '') {
				searchBar.search(searchBox.text);
				searchBox.text = ""
			}
		}
	}
}
