#ifndef HOTSPOTHELPER_H
#define HOTSPOTHELPER_H

#include <QtCore/QString>
#include <QtCore/QStringList>
#include "dbushelper.h"
#include "mobilehotspotconfiguration.h"


#define MAX_TRIES (15)
#define SYSTEM_MODULES "nf_conntrack, nf_defrag_ipv4, nf_conntrack_ipv4, x_tables, xt_mac, ip_tables, iptable_mangle, iptable_filter, nf_nat, iptable_nat, ipt_MASQUERADE" // Credits to Rambo


class HotspotHelper
{

public:
	HotspotHelper();
    ~HotspotHelper();
    static int loadSystemModules(QStringList *alreadyLoadedModules);
    static int unloadSystemModules(QStringList &alreadyLoadedModules);
    static int disableInternetConnection(MobileHotspotConfiguration &configuration);
    static int enableInternetConnection(MobileHotspotConfiguration &configuration);
    static int checkUSBMode();
    static int loadStandardUSB();
    static void unloadStandardUSB();
    static int loadNokiaUSB();
    static void unloadNokiaUSB();
    static int prepareUSBInterface(MobileHotspotConfiguration &configuration);
    static int prepareWifiInterface(MobileHotspotConfiguration &configuration);
    static int unprepareUSBInterface(MobileHotspotConfiguration &configuration);
    static int unprepareWifiInterface(MobileHotspotConfiguration &configuration);
    static int startDnsMasq(MobileHotspotConfiguration &configuration, QProcess *dnsmasqProcess);
    static int stopDnsMasq(MobileHotspotConfiguration &configuration);
    static int setIPTables(MobileHotspotConfiguration &configuration, int *ipforward);
    static int unsetIPTables(MobileHotspotConfiguration &configuration, int ipforward);

private:
	static int loadModule(QString moduleName);
	static int unloadModule(QString moduleName);
	static QStringList getSystemModules();
	static int enableUSBInterface(MobileHotspotConfiguration &configuration);
	static int setUSBMAC(MobileHotspotConfiguration &configuration);
	static int disableUSBInterface(MobileHotspotConfiguration &configuration);
	static int enableWifiInterface(MobileHotspotConfiguration &configuration);
	static int disableWifiInterface(MobileHotspotConfiguration &configuration);
	static int setPowerManagement(MobileHotspotConfiguration &configuration, bool management);
	static int setEncryption(MobileHotspotConfiguration &configuration, bool encryption);
	static int setAdhocMode(MobileHotspotConfiguration &configuration, bool adhoc);
	static QString keyToHex(QString key);
	static int setESSID(MobileHotspotConfiguration &configuration);
	static int setWifiNetwork(MobileHotspotConfiguration &configuration);
	static QString dnsmasqPIDFile(MobileHotspotConfiguration &configuration);
};

#endif // HOTSPOTHELPER_H
