/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "settings.h"
#include <QApplication>
#include <QDesktopWidget>
#include <QTimer>
#include <QDebug>

#if defined(Q_OS_SYMBIAN)
#define SETTINGS_FILE   "c://data/weather.ini"
#elif defined(Q_WS_MAEMO_5)
#define SETTINGS_FILE   "/usr/share/applications/weather.ini"
#else
#define SETTINGS_FILE   "weather.ini"
#endif

Settings::Settings()
    : m_settings(SETTINGS_FILE, QSettings::IniFormat)
{
}

Settings *Settings::instance()
{
    static Settings * const result = new Settings();
    return result;
}

QSize Settings::windowSize()
{
#ifdef Q_OS_SYMBIAN
    static const QSize result(QApplication::desktop()->screenGeometry().size());
#else
    static const QSize result(instance()->m_settings.value("windowSize").toSize());
#endif
    return result;
}

bool Settings::scaledImages()
{
    QSize size(windowSize());
    return size.width() != 480 || size.height() != 864;
}

class CitySortHelper
{
public:
    CitySortHelper(const QMap<QString, int> &map) : m_map(map) {}
    bool operator()(const QString &city1, const QString &city2)
    {
        return m_map[city1] < m_map[city2];
    }

private:
    const QMap<QString, int> &m_map;
};

QStringList Settings::getCurrentCities()
{
    return getCities("Cities");
}

QStringList Settings::getDemoCities()
{
    return getCities("Demo");
}

QStringList Settings::getCities(const QString &type)
{
    Settings *obj = instance();

    obj->m_settings.beginGroup(type);

    QStringList result = obj->m_settings.allKeys();
    QMap<QString, int> map;
    foreach(const QString &key, result)
        map[key] = obj->m_settings.value(key).toInt();

    obj->m_settings.endGroup();

    qSort(result.begin(), result.end(), CitySortHelper(map));
    return result;
}

void Settings::setCurrentCities(QStringList cities)
{
    Settings *obj = instance();
    obj->m_settings.beginGroup("Cities");
    obj->m_settings.remove("");
    for (int i = 0; i < cities.count(); ++i)
        obj->m_settings.setValue(cities[i], i);
    obj->m_settings.endGroup();
    obj->m_settings.sync();
}
