#ifndef FORECASTPROVIDER_H
#define FORECASTPROVIDER_H

#include <QObject>
#include <QString>
#include <QStringList>
#include <QList>
#include <QMap>

#include "forecastdata.h"
#include "forecastsource.h"

class ForecastProvider : public QObject
{
    Q_OBJECT
public:
    static int getForecast(const QString &key, bool locationId);

    static void connectToResponseSignal(QObject *receiver, const char *method);
    static void disconnectReceiver(QObject *receiver);

    static void setForecastSource(ForecastSource *source);

signals:
    void forecastResponse(int reqId, const ForecastData &forecast);

private:

    ForecastSource *m_source;

    ForecastProvider();
    ~ForecastProvider();
    static ForecastProvider *instance();

};

#endif // FORECASTPROVIDER_H
