/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef CITYMANAGER_H
#define CITYMANAGER_H

#include <QGraphicsItem>
#include <QGraphicsPixmapItem>

#include "addcitytool.h"
#include "citylist.h"

class CityManagerContent : public QObject, public QGraphicsItem
{
    Q_OBJECT
    Q_INTERFACES(QGraphicsItem)
    Q_PROPERTY(qreal top READ getTop WRITE setTop);
public:
    CityManagerContent(QList<ForecastData> &contentList, QGraphicsItem *parent = 0);
    void select(const QString &selected) { m_list->select(selected); }

    QRectF boundingRect () const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

    qreal getHiddenTop();

private:
    const QRectF m_boundingRect;
    AddCityTool *m_addTool;
    CityList *m_list;

    qreal getTop() { return pos().y(); }
    void setTop(qreal top) { setPos(pos().x(), top); }

private slots:
    void forecastSelected(ForecastData data);

};

class CityManager : public QObject, public QGraphicsItem
{
    Q_OBJECT
    Q_INTERFACES(QGraphicsItem)
public:
    CityManager(QList<ForecastData> contentList, QGraphicsItem *parent = 0);
    void showManager(const QString &selected);

    QRectF boundingRect () const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

    QList<ForecastData> forecastList() const { return m_contentList; }

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

signals:
    void terminated();

private:
    const QRectF m_boundingRect;
    CityManagerContent *m_content;
    QList<ForecastData> m_contentList;
    QPointer<QAbstractAnimation> m_animation;
    bool m_visible;

    void startAnimation(bool show);
};

#endif // CITYMANAGER_H
