/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef CITYINFODISPLAY_H
#define CITYINFODISPLAY_H

#include <QGraphicsItem>
#include <QGraphicsTextItem>
#include <QGraphicsSimpleTextItem>
#include <QGraphicsPixmapItem>
#include <QPen>
#include <QBrush>
#include <QFont>

class CurrentTemperatureDisplay
{
public:
    CurrentTemperatureDisplay();

    void setTemperature(int value);

    QPointF pos() const { return m_pos; }
    void setPos(QPointF pos) { m_pos = pos; }
    void setPos(qreal x, qreal y) { setPos(QPointF(x, y)); }

    QRectF boundingRect () const;
    void paint(QPainter *painter);
private:
    QPen m_pen;
    QBrush m_brush;
    QFont m_font;
    QPixmap m_sign;
    QPixmap m_unit;
    QString m_text;
    int m_value;
    QRectF m_boundingRect;
    QPointF m_pos;

    QPointF m_signPos;
    QPointF m_numberPos;
    QPointF m_unitPos;

};

class TemperatureBoundDisplay
{
public:
    TemperatureBoundDisplay(bool lowerBound);

    bool lowerBound() const { return m_lowerBound; }
    int value() const { return m_value; }
    void setValue(int value);

    QPointF pos() const { return m_pos; }
    void setPos(QPointF pos) { m_pos = pos; }
    void setPos(qreal x, qreal y) { setPos(QPointF(x, y)); }

    QRectF boundingRect () const;
    void paint(QPainter *painter);

private:
    QPen m_pen;
    QBrush m_brush;
    QFont m_font;
    QPixmap m_icon;

    QString m_text;
    int m_value;
    const bool m_lowerBound;
    QRectF m_boundingRect;
    QPointF m_pos;
};

class TemperatureDisplay
{
public:
    TemperatureDisplay();

    void setTemperature(int lowerBound, int upperBound, int current);

    QPointF pos() const { return m_pos; }
    void setPos(QPointF pos) { m_pos = pos; }
    void setPos(qreal x, qreal y) { setPos(QPointF(x, y)); }

    QRectF boundingRect () const;
    void paint(QPainter *painter);

private:
    QPixmap m_line;
    TemperatureBoundDisplay m_lowerBound;
    TemperatureBoundDisplay m_upperBound;
    CurrentTemperatureDisplay m_current;

    QRectF m_boundingRect;
    QPointF m_linePos;
    QPointF m_pos;

};

class CityInfoDisplay : public QObject, public QGraphicsItem
{
    Q_OBJECT
    Q_INTERFACES(QGraphicsItem)
public:
    CityInfoDisplay(QGraphicsItem *parent = 0);

    static int loadImages();

    void setTemperature(int lowerBound, int upperBound, int current);
    void setCityName(const QString &name);

    QRectF boundingRect () const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

signals:
    void nameClicked();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

private:
    QRectF m_boundingRect;
    TemperatureDisplay m_temperature;
    QPen m_pen;
    QBrush m_brush;
    QFont m_font;
    QString m_text;
    QPointF m_textPos;
    QRectF m_nameRect;

    void updateBoundingRect();

};

#endif // CITYINFODISPLAY_H
