/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef CALCULATORSCREEN_H
#define CALCULATORSCREEN_H

#include <QGraphicsWidget>
#include <QSignalMapper>

#include "pageslider.h"
#include "horizontalmenu.h"


class Label;
class CalculatorEngine;
class QGraphicsLinearLayout;


class CalculatorScreen : public Page
{
    Q_OBJECT

public:
    CalculatorScreen();
    ~CalculatorScreen();

    void setDisplayText(const QString &text);
    QString optionSelected();

    QRectF flickableRect() const;

signals:
    void digitPressed(int i);
    void dotPressed();
    void operatorPressed(int i);
    void equalPressed();
    void clearPressed();
    void submitPressed();

protected slots:
    void handleSubmit();
    void handleDisplayChange(const QString &display);

protected:
    void createDisplay();
    void createCarousel();
    void createKeyboard();

    QGraphicsLinearLayout *createKeyboardLine(const QStringList &items);
    void connectButton(QSignalMapper *mapper, QGraphicsLayoutItem *item,
                       int mapping);

    QGraphicsLinearLayout *mainLayout;
    Label *display;
    QSignalMapper _digitMapper;
    QSignalMapper _operatorMapper;
    HorizontalMenu *_menu;
    CalculatorEngine *m_engine;
};

#endif
