/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QGraphicsWidget>

struct Category
{
    Category() : value(0) { }

    QString name;
    qreal value;
    QColor color;
};

class BarChartGraphicsWidget : public QGraphicsWidget
{
    Q_OBJECT

    Q_PROPERTY(qreal stretch READ stretch WRITE setStretch);

public:
    BarChartGraphicsWidget();
    ~BarChartGraphicsWidget();

    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                       QWidget *widget = 0);

    void addCategory(const QString &name, qreal value, const QColor &color = QColor());
    void addCategory(const char *name, qreal value, const QColor &color = QColor());
    void updateCategoryAt(int index, qreal value);
    void clear();

    void setScale(qreal scale);

    qreal stretch() const { return _stretch; }
    void setStretch(qreal stretch);

protected:
    QColor defaultColor(int i) const;

    qreal _stretch;
    qreal _scale;
    qreal _automaticScale;
    QList<Category *> _data;
};

inline void BarChartGraphicsWidget::addCategory(const char *name, qreal value,
                                                const QColor &color)
{
    addCategory(QString(name), value, color);
}
