/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QApplication>
#include <QTimer>

#include "pdata.h"
#include "system.h"
#include "dataresource.h"
#include "calculator/calculatorscreen.h"
#include "lists/listscreen.h"
#include "chart/chartscreen.h"


int main(int argc, char **argv)
{
    QApplication app(argc, argv);
    QCoreApplication::setOrganizationName("openBossa");
    QCoreApplication::setOrganizationDomain("openbossa.org");
    QCoreApplication::setApplicationName("mybudget");

#ifndef Q_OS_SYMBIAN
    QString themeFile(QLatin1String(":/themes/mybudget.ini"));
#else
    QString themeFile(QLatin1String(":/themes/symbian.ini"));
#endif

    Resource::setIniFile(themeFile);

    QSize windowSize = Resource::value("windowSize").toSize();

    // Database
    PData *settings = new PData;
    qApp->setProperty("settings", QVariant::fromValue(settings));

    // Our contents
    QGraphicsScene scene;
    scene.setItemIndexMethod(QGraphicsScene::NoIndex);

    QGraphicsView *view = new QGraphicsView(&scene);
    view->setFrameShape(QFrame::NoFrame);
    view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view->setSceneRect(0, 0, windowSize.width(), windowSize.height());
    view->resize(windowSize);
    view->setViewportUpdateMode(QGraphicsView::BoundingRectViewportUpdate);

    view->setBackgroundBrush(Qt::black);

    PageSlider *slider = new PageSlider();
    slider->setThreshold(Qt::Vertical, 99999);
    slider->setThreshold(Qt::Horizontal, 70);

    scene.addItem(slider);
    slider->setPos(0, 0);
    slider->resize(windowSize);

    slider->addPage(new CalculatorScreen);
    slider->addPage(new ListScreen);
    slider->addPage(new ChartScreen);

    slider->setCurrentPage(1);

    System::setViewMode(view, System::PortraitMode);

#if defined(Q_OS_SYMBIAN) || defined(Q_WS_MAEMO_5)
    view->showFullScreen();
#else
    view->show();
#endif

    return app.exec();
}
