/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QFile>
#include <QTextStream>
#include <QStringList>

#include "contactresource.h"


ContactResource::ContactResource()
{
    QFile fp(":/contactlist.txt");
    fp.open(QIODevice::ReadOnly);

    QTextStream buffer(&fp);

    QHash<int, QString> values;

    while (!buffer.atEnd()) {
        const QString &line = buffer.readLine().trimmed();

        if (line.isEmpty())
            continue;

        const QStringList &parts = line.split(':');

        values[0] = parts[0];
        values[1] = parts[1];

        if (parts[2].isEmpty()) {
            values[2] = QString();
            values[3] = QString();
        } else {
            values[2] = QString("list_photo_%1").arg(parts[2]);
            values[3] = QString("call_photo_%1").arg(parts[2]);
        }

        m_values.append(values);
    }

    fp.close();
}

ContactResource::~ContactResource()
{

}

QString ContactResource::data(int index, int role) const
{
    if (index < 0 || index >= m_values.count())
        return QString();
    else
        return m_values[index].value(role, QString());
}

ContactResource *ContactResource::instance()
{
    static ContactResource result;
    return &result;
}

int ContactResource::count()
{
    return instance()->m_values.count();
}

QString ContactResource::name(int index)
{
    return instance()->data(index, 0);
}

QString ContactResource::phone(int index)
{
    return instance()->data(index, 1);
}

QString ContactResource::photo(int index, PhotoSize type)
{
    return instance()->data(index, (type == SmallPhoto) ? 2 : 3);
}

int ContactResource::indexFromPhone(const QString &phone)
{
    ContactResource *d = instance();

    int total = count();
    for (int i = 0; i < total; i++) {
        if (phone == d->data(i, 1))
            return i;
    }

    return -1;
}
