/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QPainter>

#include "label.h"


Label::Label(QGraphicsItem *parent)
    : QGraphicsWidget(parent),
      m_fontColor(Qt::white),
      m_alignment(Qt::AlignLeft),
      m_elideMode(Qt::ElideRight)
{
    setFont(QFont("Nokia Sans"));
}

QString Label::text() const
{
    return m_text;
}

void Label::setText(const QString &value)
{
    if (m_text != value) {
        m_text = value;
        update();
    }
}

QColor Label::fontColor() const
{
    return m_fontColor;
}

void Label::setFontColor(const QColor &color)
{
    if (m_fontColor != color) {
        m_fontColor = color;
        update();
    }
}

Qt::TextElideMode Label::elideMode() const
{
    return m_elideMode;
}

void Label::setElideMode(Qt::TextElideMode mode)
{
    if (m_elideMode != mode) {
        m_elideMode = mode;
        update();
    }
}

void Label::setAlignment(Qt::Alignment alignment)
{
    if (m_alignment != alignment) {
        m_alignment = alignment;
        update();
    }
}

void Label::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                  QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    if (m_text.isEmpty())
        return;

    const QRect &textRect = boundingRect().toRect();

    QFontMetrics metrics(font());
    const QString &elidedText = metrics.elidedText(m_text, m_elideMode,
                                                   textRect.width());

    painter->setFont(font());
    painter->setPen(m_fontColor);
    painter->drawText(textRect, Qt::TextSingleLine | m_alignment, elidedText);
}
