/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef FORECASTMODEL_H
#define FORECASTMODEL_H

#include <QObject>
#include <QStringList>

#include "forecastdata.h"

class ForecastResolver;


class ForecastModel : public QObject
{
    Q_OBJECT

public:
    static ForecastModel *instance();

    void load(bool force = false);

    int count() const;
    ForecastData itemAt(int index) const;
    int indexOf(const ForecastData &forecast) const;

    void add(const ForecastData &forecast);
    void remove(const ForecastData &forecast);

    void saveToDisk();

    int resolveById(const QString &id);
    int resolveByQuery(const QString &query);

    static QString source();
    static void setSource(const QString &name);
    static void setResolver(ForecastResolver *resolver);

signals:
    void loaded();
    void modelResolved(int reqId, const ForecastData &forecast);

    void itemAdded(const ForecastData &data);
    void itemRemoved(const ForecastData &data);

protected:
    ForecastModel();

private slots:
    void onModelResolved(int reqId, const ForecastData &forecast);
    void onForecastResolved(int reqId, WeatherResponse *response);
    void onForecastResponseError(int reqId);

private:
    bool m_isLoaded;
    QStringList m_keys;
    QList<int> m_requests;
    QString m_source;
    QList<ForecastData> m_data;
    ForecastResolver *m_resolver;
};

#endif
