/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef FORECASTHUNGITEM_H
#define FORECASTHUNGITEM_H

#include <QObject>
#include <QGraphicsItem>
#include <QAbstractAnimation>

class ForecastHungItem : public QObject, public QGraphicsItem
{
    Q_OBJECT
    Q_INTERFACES(QGraphicsItem)
    Q_PROPERTY(qreal picTop READ picTop WRITE setPicTop)
public:
    enum ItemType {
        Cloud1 = 0,
        Cloud2,
        Cloud3,
        CloudRain1,
        CloudRain2,
        CloudRain3,
        CloudStorm1,
        CloudStorm2,
        CloudStorm3,
        CloudTStorm1,
        CloudTStorm2,
        Sun,
        ColdSun,
        Moon,
        NoForecast,
        TypeCount
    };

    static int loadImages();

    ForecastHungItem(ItemType type, QGraphicsItem *parent = 0);
    QAbstractAnimation *getAnimation();

    qreal lineLenght() const;
    void setLineLenght(qreal lenght);
    void setLinePos(qreal linePos);

    QPointF picPos() const;
    void setPicPos(QPointF pos);
    void setPicPos(qreal x, qreal y) { setPicPos(QPointF(x, y)); }

    void reset();

    QRectF boundingRect () const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

private:
    QGraphicsPixmapItem *m_pic;
    QGraphicsPixmapItem *m_line;
    ItemType m_type;
    qreal m_targetPicTop;

    qreal picTop() const { return m_pic->pos().y(); }
    void setPicTop(qreal top) { m_pic->setPos(m_pic->pos().x(), top); }

};

#endif // FORECASTHUNGITEM_H
