/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef IMTKLISTVIEW_H
#define IMTKLISTVIEW_H

#include <QPointF>
#include <QGraphicsWidget>

#include "model.h"
#include "global.h"
#include "widget.h"

class ImtkListView;
class ImtkListViewItem;
class ImtkListViewPrivate;
class ImtkListViewItemPrivate;
class ImtkKineticListViewPrivate;


class IMTK_EXPORT ImtkAbstractListViewCreator
{
public:
    virtual ImtkListViewItem *create() = 0;
};


template <typename T>
class IMTK_EXPORT ImtkListViewCreator : public ImtkAbstractListViewCreator
{
public:
    ImtkListViewItem *create() { return new T(); }
};


class IMTK_EXPORT ImtkListViewItem : public QGraphicsItem
{
public:
    ImtkListViewItem(QGraphicsItem *parent = 0);
    ~ImtkListViewItem();

    int index() const;
    bool isPressed() const;

    QSizeF size() const;
    QRectF boundingRect() const;

    QSizeF preferredSize() const;
    void setPreferredSize(const QSizeF &size);

protected:
    ImtkListView *listView() const;
    void resize(const QSizeF &value);

    virtual void contentsChanged();
    virtual void selectionChanged();
    virtual void indexChange(int oldIndex, int newIndex);

private:
    ImtkListViewItemPrivate *d;

    friend class ImtkListView;
    friend class ImtkListViewPrivate;
    friend class ImtkListViewItemPrivate;
};


class IMTK_EXPORT ImtkListView : public ImtkWidget
{
    Q_OBJECT

public:
    ImtkListView(QGraphicsItem *parent = 0);
    ~ImtkListView();

    ImtkAbstractModel *model() const;
    void setModel(ImtkAbstractModel *model);

    int offset() const;
    int maximumOffset() const;

    void setCreator(ImtkAbstractListViewCreator *creator);

    int indexAtOffset(int offset);
    ImtkListViewItem *itemFromIndex(int index);

signals:
    void offsetChanged();
    void maximumOffsetChanged();
    void itemClicked(int index);

public slots:
    void setOffset(int position);

protected:
    ImtkListView(ImtkListViewPrivate &dptr, QGraphicsItem *parent = 0);

    virtual void modelChanged();
    void resizeEvent(QGraphicsSceneResizeEvent *event);
    void setItemPressed(ImtkListViewItem *item, bool pressed);

protected slots:
    void reconfigureRenderers();

    virtual void itemAdded(int index);
    virtual void itemChanged(int index);
    virtual void itemRemoved(int index);
    virtual void itemMoved(int oldIndex, int newIndex);

private:
    IMTK_DECLARE_PRIVATE(ImtkListView);
};


class IMTK_EXPORT ImtkKineticListView : public ImtkListView
{
    Q_OBJECT

public:
    ImtkKineticListView(QGraphicsItem *parent = 0);
    ~ImtkKineticListView();

public Q_SLOTS:
    void kineticMove(int);

protected:
    ImtkKineticListView(ImtkKineticListViewPrivate &dptr, QGraphicsItem *parent = 0);

    void modelChanged();
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

private:
    IMTK_DECLARE_PRIVATE(ImtkKineticListView);
};

#endif
