#ifndef WEATHERRESPONSE_H
#define WEATHERRESPONSE_H

#include <QTime>
#include <QDate>
#include <QString>
#include <QDebug>
#include <QDateTime>

#include "forecast.h"


class WeatherResponse
{
public:
    enum TemperatureUnit {
        Fahrenheit,
        Celsius
    };

    struct
    {
        QString city;
        QString region;
        QString country;
        double latitude;
        double longitude;
        double timeZone;
    } location;

    struct
    {
        QTime sunrise;
        QTime sunset;
    } astronomy;

    struct
    {
        QString text;
        Forecast::ForecastType code;
        int temperature;
        QDateTime date;
    } condition;

    struct WeekForecast
    {
        Forecast::ForecastType code;
        int low;
        int high;
        QDate date;
        QString text;
        QString weekdayName;
        bool valid;

        WeekForecast() {}
        WeekForecast(const WeekForecast &d)
            : code(d.code), low(d.low),
              high(d.high), date(d.date),
              text(d.text), weekdayName(d.weekdayName),
              valid(d.valid) { }
    } forecast1;


    QList<WeekForecast> forecasts;

    QDateTime buildDate;
    int timeToLive;
    QDateTime pubDate;

public:
    WeatherResponse(const QString &locationCode)
        : m_locationCode(locationCode)
    {

    }

    virtual bool isNight() const = 0;

    QString locationCode() const { return m_locationCode; }

private:
    QString m_locationCode;
};

#endif
