TEMPLATE = app
TARGET = mobile-weather.bin
QT += network xml
target.path = $$PREFIX/bin
INSTALLS += target

MOC_DIR = tmp
OBJECTS_DIR = tmp

unix {
   CONFIG += static
   LIBS += ../libimtk.a
   INCLUDEPATH += ../imtk/
}

symbian {
    TARGET.UID3 = 0xe2844567
    TARGET.CAPABILITY = NetworkServices
    TARGET.EPOCHEAPSIZE = 0x20000 0x2000000

    ICON = ../resource/icon-weather.svg

    LIBS += -lesock \
            -lconnmon \
            -lcone \
            -lavkon \
            -limtk

    addFiles.sources = weather.ini
    addFiles.path = c:\data
    DEPLOYMENT += addFiles

    isEmpty(IMTK_PATH) {
        error("You must specify IMTK_PATH variable. Use qmake IMTK_PATH=/path/to/include")
    }

    INCLUDEPATH += $$IMTK_PATH

    isEmpty(RESOLUTION) {
        RESOLUTION = "640x360"
    }
}


HEADERS += utils.h \
    system.h \
    settings.h \
    loadingscreen.h \
    forecastview.h \
    forecasthungitem.h \
    forecaststars.h \
    forecastsnow.h \
    forecastrain.h \
    forecast.h \
    carroussel.h \
    citycarroussel.h \
    cityinfodisplay.h \
    pixmaploader.h \
    forecastdata.h \
    contentlist.h \
    citylist.h \
    addcitytool.h \
    symbiannetwork.h \
    locationresolver.h \
    forecastresolver.h \
    weatherresponse.h \
    citypanel.h \
    forecastmodel.h \
    optionspanel.h \
    optionslist.h \
    mainwindow.h \
    datasource/yahoolocationresolver.h \
    datasource/yahooforecastresolver.h \
    datasource/yahooweatherresponse.h \
    datasource/bbclocationresolver.h \
    datasource/bbcforecastresolver.h \
    datasource/bbcweatherresponse.h \
    datasource/demoforecastresolver.h

SOURCES += main.cpp \
    system.cpp \
    utils.cpp \
    loadingscreen.cpp \
    settings.cpp \
    forecastview.cpp \
    forecasthungitem.cpp \
    forecaststars.cpp \
    forecastsnow.cpp \
    forecastrain.cpp \
    citycarroussel.cpp \
    cityinfodisplay.cpp \
    pixmaploader.cpp \
    contentlist.cpp \
    citylist.cpp \
    addcitytool.cpp \
    forecastdata.cpp \
    locationresolver.cpp \
    forecastresolver.cpp \
    citypanel.cpp \
    forecastmodel.cpp \
    optionspanel.cpp \
    optionslist.cpp \
    mainwindow.cpp \
    datasource/yahoolocationresolver.cpp \
    datasource/yahooforecastresolver.cpp \
    datasource/yahooweatherresponse.cpp \
    datasource/bbclocationresolver.cpp \
    datasource/bbcforecastresolver.cpp \
    datasource/bbcweatherresponse.cpp \
    datasource/demoforecastresolver.cpp


isEmpty(RESOLUTION) {
    RESOLUTION = "800x480"
    #RESOLUTION = "640x360"
}

RESOURCES = ../resource/$$RESOLUTION/resource.qrc

QMAKE_MACOSX_DEPLOYMENT_TARGET = 10.5
