/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef PIXMAPLOADER_H
#define PIXMAPLOADER_H

#include <QThread>
#include <QMutex>
#include <QMap>
#include <QStringList>
#include <QPixmap>
#include <QWaitCondition>

class PixmapLoader;

class PixmapLoaderThread : public QThread
{
    Q_OBJECT
public:
    PixmapLoaderThread(PixmapLoader *loader);
signals:
    void imageIsReady(const QString &name, QImage image);
protected:
    void run();
private:
    PixmapLoader * const m_loader;

};

class PixmapLoader : public QObject
{
    Q_OBJECT
public:
    static void load(const QString &name);
    static void connectToOnIdleSignal(QObject *receiver, const char *method);
    static void disconnectReceiver(QObject *receiver);
    static QPixmap pixmap(const QString &name);

signals:
    void onIdle();

private:
    friend class PixmapLoaderThread;
    QMutex m_mutex;
    QWaitCondition m_condition;

    QStringList m_queue;
    QStringList m_currentImages;
    QMap<QString, QPixmap> m_store;
    PixmapLoaderThread *m_thread;

    PixmapLoader(QObject *parent = 0);
    static PixmapLoader *instance();

    void enqueue(const QString &name);
    QString doDequeue();
    QString dequeue();

private slots:
    void imageIsReady(const QString &name, QImage image);
};

#endif // PIXMAPLOADER_H
