/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QTimer>
#include <QPainter>

#include "throbber.h"
#include "widget_p.h"
#include "utils.h"
#include "dataresource.h"


class ImtkThrobberPrivate : public ImtkWidgetPrivate
{
public:
    ImtkThrobberPrivate(ImtkThrobber *q_ptr);

    QTimer timer;
    int interval;
    int currentFrame;
    QList<QPixmap> images;

    void _q_nextImage();

    IMTK_DECLARE_PUBLIC(ImtkThrobber);
};

ImtkThrobberPrivate::ImtkThrobberPrivate(ImtkThrobber *q_ptr)
    : ImtkWidgetPrivate(q_ptr),
      interval(30),
      currentFrame(0)
{

}

void ImtkThrobberPrivate::_q_nextImage()
{
    Q_Q(ImtkThrobber);

    if (++currentFrame >= images.length())
        currentFrame = 0;

    q->update();
}


ImtkThrobber::ImtkThrobber(QGraphicsItem *parent)
    : ImtkWidget(*new ImtkThrobberPrivate(this), parent)
{
    Q_D(ImtkThrobber);
    connect(&(d->timer), SIGNAL(timeout()), SLOT(_q_nextImage()));
}

ImtkThrobber::ImtkThrobber(const QList<QPixmap> &images,
                           QGraphicsItem *parent)
    : ImtkWidget(*new ImtkThrobberPrivate(this), parent)
{
    Q_D(ImtkThrobber);
    connect(&(d->timer), SIGNAL(timeout()), SLOT(_q_nextImage()));

    setImages(images);
}

ImtkThrobber::~ImtkThrobber()
{
    Q_D(ImtkThrobber);
    d->timer.stop();
    d->images.clear();
}

void ImtkThrobber::setImages(const QList<QPixmap> &images)
{
    Q_D(ImtkThrobber);

    if (images.count() == 0 || images[0].isNull())
        return;

    setMinimumSize(images[0].size());
    setMaximumSize(images[0].size());

    d->images.clear();
    d->currentFrame = 0;
    foreach (const QPixmap &pixmap, images)
        d->images.append(pixmap);

    update();
}

void ImtkThrobber::setInterval(int msec)
{
    Q_D(ImtkThrobber);
    d->interval = msec;
}

int ImtkThrobber::interval() const
{
    Q_D(const ImtkThrobber);
    return d->interval;
}

void ImtkThrobber::start()
{
    Q_D(ImtkThrobber);
    d->timer.start(d->interval);
}

void ImtkThrobber::stop()
{
    Q_D(ImtkThrobber);
    d->timer.stop();
}

void ImtkThrobber::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                         QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    Q_D(ImtkThrobber);

    if (d->images.empty())
        return;

    bDrawPixmap(painter, d->images[d->currentFrame], boundingRect());
}

#include "moc_throbber.cpp"
