/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef IMTKPAGESLIDER_H
#define IMTKPAGESLIDER_H

#include <QGraphicsWidget>

#include "global.h"
#include "flickablearea.h"


class ImtkPage;
class ImtkPageSliderPrivate;


class IMTK_EXPORT ImtkPage : public QGraphicsWidget
{
    Q_OBJECT

public:
    ImtkPage(QGraphicsItem *parent = 0);

    virtual QRectF flickableRect() const;

    bool isFullOpaque() const;
    void setFullOpaque(bool opaque);

    QPainterPath opaqueArea() const;

private:
    bool m_fullOpaque;
};


class IMTK_EXPORT ImtkPageSlider : public ImtkFlickableArea
{
    Q_OBJECT

public:
    ImtkPageSlider(QGraphicsItem *parent = 0);
    ~ImtkPageSlider();

    bool addPage(ImtkPage *view);
    bool removePage(ImtkPage *view);

    int currentPage() const;
    void setCurrentPage(int index);

    int pageCount() const;

    int adjustmentThreshold() const;
    void setAdjustmentThreshold(int value);

    bool moveLeft();
    bool moveRight();

protected:
    void mouseSlideStarted(const QPointF &pos);
    void mouseSlideMoved(const QPointF &pos);
    void mouseSlideFinished(const QPointF &pos);

    void resizeEvent(QGraphicsSceneResizeEvent *event);

private slots:
    void transitionFinished();

private:
    IMTK_DECLARE_PRIVATE(ImtkPageSlider);
};

#endif
