/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef CITYINFODISPLAY_H
#define CITYINFODISPLAY_H

#include <QGraphicsItem>
#include <QGraphicsTextItem>
#include <QGraphicsSimpleTextItem>
#include <QGraphicsPixmapItem>
#include <QGraphicsWidget>
#include <QPen>
#include <QBrush>
#include <QFont>

class CurrentTemperatureDisplay
{
public:
    CurrentTemperatureDisplay();

    void setTemperature(int value);

    QPointF pos() const { return m_pos; }
    void setPos(QPointF pos) { m_pos = pos; }
    void setPos(qreal x, qreal y) { setPos(QPointF(x, y)); }

    QRectF boundingRect () const;
    void paint(QPainter *painter);
private:
    QPen m_pen;
    QBrush m_brush;
    QFont m_font;
    QPixmap m_sign;
    QPixmap m_unit;
    QString m_text;
    int m_value;
    QRectF m_boundingRect;
    QPointF m_pos;

    QPointF m_signPos;
    QPointF m_numberPos;
    QPointF m_unitPos;

};

class TemperatureBoundDisplay
{
public:
    TemperatureBoundDisplay(bool lowerBound);

    bool lowerBound() const { return m_lowerBound; }
    int value() const { return m_value; }
    void setValue(int value);

    QPointF pos() const { return m_pos; }
    void setPos(QPointF pos) { m_pos = pos; }
    void setPos(qreal x, qreal y) { setPos(QPointF(x, y)); }

    QRectF boundingRect () const;
    void paint(QPainter *painter);

private:
    QPen m_pen;
    QBrush m_brush;
    QFont m_font;
    QPixmap m_icon;

    QString m_text;
    int m_value;
    const bool m_lowerBound;
    QRectF m_boundingRect;
    QPointF m_pos;
};

class ForecastDisplay
{
public:
    ForecastDisplay();

    void setValue(const QString &week, int lower, int upper);

    void paint(QPainter *painter);

private:
    QPointF m_weekPos;
    QPointF m_linePos;
    QPointF m_maxIconPos;
    QPointF m_minIconPos;
    QPointF m_maxCelsiusPos;
    QPointF m_minCelsiusPos;
    QPointF m_upperPos;
    QPointF m_lowerPos;

    QPen m_pen;
    QPen m_weekPen;
    QFont m_font;
    QFont m_weekFont;
    QPixmap m_line;
    QPixmap m_minIcon;
    QPixmap m_maxIcon;
    QPixmap m_celsius;

    QString m_lower;
    QString m_upper;
    QString m_week;
    QRectF m_boundingRect;
};

class CityInfoDisplay : public QObject, public QGraphicsItem
{
    Q_OBJECT
    Q_INTERFACES(QGraphicsItem)
public:
    CityInfoDisplay(QGraphicsItem *parent = 0);

    static int loadImages();

    void setForecast(const QString &weekday, int lower, int upper);

    void setTemperature(int current);
    void setTemperature(int current, int lower, int upper);

    QRectF boundingRect () const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

protected:
    void setTemperature(int lowerBound, int upperBound, int current,
                        bool showUpperLower);

private:
    bool m_isForecast;
    QRectF m_boundingRect;

    QPen m_pen;
    QFont m_font;

    QPixmap m_line;
    bool m_showUpperLower;
    ForecastDisplay m_forecast;
    TemperatureBoundDisplay m_lowerBound;
    TemperatureBoundDisplay m_upperBound;
    CurrentTemperatureDisplay m_current;

    QPointF m_linePos;
    QPointF m_pos;
};


#endif // CITYINFODISPLAY_H
