/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QSettings>

#ifdef Q_OS_LINUX
#include <QX11Info>
#endif

#include "utils.h"
#include "dataresource.h"


ImtkResource::ImtkResource()
    : settings(new QSettings()),
      pixmapPrefix(":/")
{

}

ImtkResource::~ImtkResource()
{
    delete settings;
}

ImtkResource *ImtkResource::instance()
{
    static ImtkResource result;
    return &result;
}

void ImtkResource::setIniFile(const QString &fileName)
{
    ImtkResource *d = instance();

    if (d->settings)
        delete d->settings;

    d->settings = new QSettings(fileName, QSettings::IniFormat);
}

QPixmap ImtkResource::pixmap(const QString &path)
{
    ImtkResource *d = instance();

#ifdef Q_OS_LINUX
    // apply dithering for 16 bits displays
    if (QX11Info::appDepth() == 16) {
        QImage rawImage(QString("%1%2").arg(d->pixmapPrefix, path));
        return QPixmap::fromImage(convertARGB32ToARGB8565(rawImage));
    }
#endif

    return QPixmap(QString("%1%2").arg(d->pixmapPrefix, path));
}

void ImtkResource::setPixmapPrefix(const QString &prefix)
{
    ImtkResource *d = instance();
    d->pixmapPrefix = prefix;
}

QImage ImtkResource::applyDithering(const QImage &image)
{
    return convertARGB32ToARGB8565(image);
}

bool ImtkResource::containsValue(const QString &key)
{
    ImtkResource *d = instance();
    return d->settings->contains(key);
}

QVariant ImtkResource::value(const QString &key, const QVariant &value)
{
    ImtkResource *d = instance();

    if (d->settings->contains(key))
        return d->settings->value(key, value);
    else {
        qWarning("ImtkResource: key '%s' not found", key.toLatin1().data());
        return QVariant();
    }
}

int ImtkResource::intValue(const QString &key, int value)
{
    return ImtkResource::value(key, value).toInt();
}

double ImtkResource::doubleValue(const QString &key, double value)
{
    return ImtkResource::value(key, value).toDouble();
}

QString ImtkResource::stringValue(const QString &key, const QString &value)
{
    return ImtkResource::value(key, value).toString();
}
