#/bin/sh
#Arguments:
# 1 = full path to the theme config file to activate
theme=${1-"/opt/qtlockscreen/default.ini"}

echo "Setting theme: $theme"
rm -f /home/user/.config/sakya/QtLockscreen.ini || { exit 1; }
ln -s "$theme" /home/user/.config/sakya/QtLockscreen.ini || { exit 1; }

if [ ! -z "$(pidof qtlockscreen)" ]; then
    echo "Killing qtlockscreen"
    killall -9 qtlockscreen;
fi

sleep 2
if [ -z "$(pidof qtlockscreen)" ]; then
    echo "Restarting qtlockscreen (didn't respawn)"
    bg qtlockscreen || { exit 1; }
fi

echo "Done"