#include "screenshotmaker.h"
#include <QProcess>
#include <QDebug>

ScreenshotMaker::ScreenshotMaker(QObject *parent, QList<Theme*> themes) :
    QThread(parent)
{
    m_Themes = themes;
}

void ScreenshotMaker::run()
{
    QString tempFile = "/tmp/qtl.png";

    foreach(Theme* t, m_Themes){
        if (t->screenshot.isNull()){
            qDebug() << "Getting screenshot for theme" << t->name;
            //Get screenshot:
            QProcess p;
            p.start(QString("/usr/bin/qtlockscreen -s \"%1\" -c \"%2\"").arg(tempFile).arg(t->file));
            if (p.waitForFinished(10000)){
                if (p.exitCode() == 0){
                    qDebug() << "  Done.";
                    emit screenshot(t, tempFile);
                }else
                    qDebug() << "Process exited with code" << p.exitCode();
            }else{
                qDebug() << "Failed to wait for process finished";
            }
            p.kill();
        }
    }
}
