//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LOCKSCREEN_H
#define LOCKSCREEN_H
#include <QtGui>
#include "widgets/lswidgets.h"
#include "backends/systemplayer.h"

#ifdef Q_WS_MAEMO_5
    #include <QDBusMessage>
    #include <QDBusConnection>
    #include <QDBusInterface>
#endif

class LockScreen : public QObject
{
    Q_OBJECT
public:
    LockScreen();

    static bool isLocked();
    bool show();
    bool hide();
    static bool Debug;

private:
    bool m_WasPortrait;
    SystemPlayer* m_Player;
    QGraphicsScene m_Scene;
    QGraphicsView* m_View;

    void setHildonFlags();
    void setBackground();
    void createWidgets();
    void deleteWidgets();    

    bool m_isDialogActive;
    QString m_tklockState;

    void startUpdate();
    void stopUpdate();

    QString m_BkgPath;
    void setSizeAndPosition();

private slots:
    LsWidget* createWidget(QString type, QString name);
    void onDisplayStateChangedSlot(QString displayState);
    void onTkLockChanged(QString locked);
    void onCallStateChanged(QString);
#ifdef Q_WS_MAEMO_5
    void onOrientationChanged(QDBusMessage);
    void onIncomingCallSlot(QDBusMessage);
    void onAlarmDialogStatusChanged(QDBusMessage);
#endif
};

#endif // LOCKSCREEN_H
