//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lswidget.h"
#include <QApplication>
#include <QDesktopWidget>

LsWidget::LsWidget(QString name)
{
    m_Name = name;

    setFlag(QGraphicsItem::ItemIsMovable, false);
    setFlag(QGraphicsItem::ItemIsSelectable, false);
    setFlag(QGraphicsItem::ItemIsFocusable, false);
    setFlag(QGraphicsItem::ItemClipsToShape, true);
    setFlag(QGraphicsItem::ItemClipsChildrenToShape, true);
}

QVariant LsWidget::getSetting(QString name, QVariant defaultValue)
{
    return QSettings().value(QString("%1/%2").arg(m_Name).arg(name), defaultValue);
}

QPoint LsWidget::getPosSetting(QPoint defaultValue)
{
    QString name;
    if (isPortrait())
        name = "PosP";
    else
        name = "PosL";

    return getPosSetting(name, defaultValue);
}

QPoint LsWidget::getPosSetting(QString name, QPoint defaultValue)
{
    QString pos = getSetting(name, "").toString();
    QStringList elem = pos.split(';');
    if (elem.count() == 2){        
#ifdef Q_WS_MAEMO_5
        QSize s = QApplication::desktop()->size();
#else
        QSize s(800,480);
#endif
        int x = 0;
        int y = 0;
        if (elem.at(0) == "center")
            x = s.width() / 2 - size().width() / 2;
        else if (elem.at(0) == "left")
            x = 0;
        else if (elem.at(0) == "right")
            x = s.width() - size().width();
        else
            x = elem.at(0).toInt();

        if (elem.at(1) == "center")
            y = s.height() / 2 - size().height() / 2;
        else if (elem.at(1) == "top")
            y = 0;
        else if (elem.at(1) == "bottom")
            x = s.height() - size().height();
        else
            y = elem.at(1).toInt();

        return QPoint(x, y);
    }
    return defaultValue;
}

QSize LsWidget::getSizeSetting(QSize defaultValue)
{
    QString name;
    if (isPortrait())
        name = "SizeP";
    else
        name = "SizeL";

    return getSizeSetting(name, defaultValue);
}

QSize LsWidget::getSizeSetting(QString name, QSize defaultValue)
{
    QString size = getSetting(name, QString("%0;%1").arg(defaultValue.width())
                              .arg(defaultValue.height())).toString();
    QStringList elem = size.split(';');
    if (elem.count() == 2)
        return QSize(elem.at(0).toInt(), elem.at(1).toInt());
    return defaultValue;
}

QColor LsWidget::getColorSetting(QString name, QColor defaultValue)
{
    QString color = getSetting(name, "").toString();
    QStringList elem = color.split(';');
    if (elem.count() == 4)
        return QColor(elem.at(0).toInt(), elem.at(1).toInt(), elem.at(2).toInt(), elem.at(3).toInt());
    else if (elem.count() == 3)
        return QColor(elem.at(0).toInt(), elem.at(1).toInt(), elem.at(2).toInt());
    return defaultValue;
}

Qt::AlignmentFlag LsWidget::getAlignmentSetting(QString name, Qt::AlignmentFlag defaultValue)
{
    QString align = getSetting(name, "").toString();
    align = align.toLower().trimmed();

    if (align == "center")
        return Qt::AlignHCenter;
    else if (align == "left")
        return Qt::AlignLeft;
    else if (align == "right")
        return Qt::AlignRight;
    return defaultValue;
}

QFont LsWidget::getFontSetting(QString name, QFont defaultValue)
{
    QString fSettings = getSetting(name, "").toString();
    if (!fSettings.isEmpty()){
        QStringList elem = fSettings.split(';');
        if (elem.count() == 4){
            QString family = elem.at(0);
            if (family.isEmpty())
                family = QApplication::font().family();
            int pointSize = elem.at(1).toInt();
            if (pointSize <= 0)
                pointSize = 12;

            int weight = QFont::Normal;
            QString sWeight = elem.at(2).toLower();
            if (sWeight == "light")
                weight = QFont::Light;
            else if (sWeight == "normal")
                weight = QFont::Normal;
            else if (sWeight == "demibold")
                weight = QFont::DemiBold;
            else if (sWeight == "bold")
                weight = QFont::Bold;
            else if (sWeight == "black")
                weight = QFont::Black;
            bool italic = elem.at(3).toInt() == 1;

            return QFont(family, pointSize, weight, italic);
        }
    }
    return defaultValue;
}

void LsWidget::setName(QString name)
{
    m_Name = name;
}

QString LsWidget::name()
{
    return m_Name;
}

void LsWidget::setSize(QSize size)
{
    m_Size = QRectF(0,0, size.width(), size.height());
}

QRectF LsWidget::size()
{
    return m_Size;
}

QRectF LsWidget::boundingRect() const
{
    return QRectF(0,0, m_Size.width(), m_Size.height());
}

QRectF LsWidget::sceneRect()
{
    QRectF u(boundingRect());
    u.setTop(pos().y());
    u.setHeight(u.height() + pos().y());
    u.setLeft(pos().x());
    u.setWidth(u.width() + pos().x());
    return u;
}

void LsWidget::update()
{
    if (scene() != NULL){
        qDebug() << "Updating widget" << m_Name;
        QGraphicsItem::update(boundingRect());
    }
}

bool LsWidget::isPortrait()
{
    return QApplication::desktop()->width() < QApplication::desktop()->height();
}

void LsWidget::setSizeAndPosition(QSize defaultSize, QPoint defaultPos)
{
    setSize(getSizeSetting(defaultSize));
    setPos(getPosSetting(defaultPos));
}
