//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsslidetounlock.h"

LsSlideToUnlock::LsSlideToUnlock(QString name) :
        LsWidget(name.isEmpty() ? "SlideToUnlock": name)
{
    applySettings();
}

void LsSlideToUnlock::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
                            QWidget*)
{
    if (!m_BackgroundImage.isNull()){
        painter->drawPixmap(0,0,m_BackgroundImage);
    }

}

void LsSlideToUnlock::applySettings()
{
    m_SliderImage = QPixmap(getSetting("SliderImage", "").toString());
    m_BackgroundImage = QPixmap(getSetting("BackgroundImage", "").toString());

    setSizeAndPosition(QSize(100, 100), QPoint(0, 0));
}
