//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSNOTIFICATION_H
#define LSNOTIFICATION_H
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QSqlError>
#include "lswidget.h"

class LsNotification : public LsWidget
{
public:
    enum Notifications
    {
        NotificationNone,
        NotificationMissedCall,
        NotificationNewSMS,
        NotificationNewEmail,
        NotificationNewChat,
    };

    LsNotification(QString name="");

    void paint(QPainter *painter, const QStyleOptionGraphicsItem*, QWidget*);
    void applySettings();
    void stopUpdate();
    void startUpdate();

private:
    QSqlDatabase m_Db;
    Notifications m_Type;
    QPixmap m_Icon;
    QString m_Text;
    QFont m_Font;
    QColor m_Color;


    void updateNotification();
};

#endif // LSNOTIFICATION_H
