//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsrect.h"

LsRect::LsRect(QString name) :
        LsWidget(name.isEmpty() ? "Rect": name)
{
    applySettings();
}

void LsRect::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
                   QWidget*)
{
    painter->setBrush(m_Color);
    painter->setPen(Qt::NoPen);
    painter->drawRoundedRect(boundingRect(), m_Radius, m_Radius);
}

void LsRect::applySettings()
{
    setSizeAndPosition(QSize(50, 50), QPoint(0, 0));

    m_Color = getColorSetting("Color", QColor(0,0,0,150));
    m_Radius = getSetting("Radius", 15.0).toFloat();
}
