//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSTEXTCOMMAND_H
#define LSTEXTCOMMAND_H
#include <QTimer>
#include <QDateTime>
#include <QProcess>
#include "lstext.h"

class LsTextCommand : public QObject, public LsText
{
    Q_OBJECT
public:
    LsTextCommand(QString name="");

    void applySettings();
    void stopUpdate();
    void startUpdate();

private:
    QTimer* m_Timer;
    QDateTime m_LastUpdate;
    QProcess* m_Process;
    QString m_Command;
    int m_UpdateInterval;

private slots:
    void executeCommand();
    void onProcessFinished(int exitCode, QProcess::ExitStatus);

};

#endif // LSTEXTCOMMAND_H
