//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsmediametadata.h"

LsMediaMetadata::LsMediaMetadata(QString name, SystemPlayer* player) :
        LsWidget(name.isEmpty() ? "MediaMetadata": name)
{
    m_Player = player;
    m_Artist = tr("Unknown artist");
    m_Title = tr("Unknown title");
    applySettings();
}

void LsMediaMetadata::paint(QPainter *painter, const QStyleOptionGraphicsItem* option,
                            QWidget*)
{
    painter->setClipRect(option->exposedRect);

    QFontMetrics tfm(m_TitleFont);
    QString title = tfm.elidedText(m_Title, Qt::ElideRight, option->exposedRect.width());

    QFontMetrics afm(m_ArtistFont);
    QString artist = afm.elidedText(m_Artist, Qt::ElideRight, option->exposedRect.width());

    QRectF rect(boundingRect());

    painter->setFont(m_TitleFont);
    painter->setPen(m_TitleColor);
    painter->drawText(rect, m_Alignment | Qt::TextSingleLine, title);

    QFontMetrics fm(m_TitleFont);
    QSize size = fm.size(Qt::TextSingleLine, title);
    rect.setTop(rect.top() + size.height() + MINIMUM_TEXT_MARGIN);

    painter->setFont(m_ArtistFont);
    painter->setPen(m_ArtistColor);
    painter->drawText(rect, m_Alignment | Qt::TextSingleLine, artist);
}

void LsMediaMetadata::applySettings()
{
    m_Alignment = getAlignmentSetting("Alignment", Qt::AlignHCenter, Qt::AlignTop);
    m_TitleColor = getColorSetting("TitleColor", QColor(255,255,255));
    m_ArtistColor = getColorSetting("ArtistColor", QColor(255,255,255));

    m_TitleFont = getFontSetting("TitleFont", QFont("", 20, QFont::Normal, false));
    m_ArtistFont = getFontSetting("ArtistFont", QFont("", 14, QFont::Normal, false));

    setSizeAndPosition(QSize(100, 100), QPoint(0, 0));
}

void LsMediaMetadata::stopUpdate()
{
    if (m_Player){
        disconnect(m_Player, SIGNAL(metadataChanged(QMap<QString,QVariant>)), this, SLOT(onMetadataChanged(QMap<QString,QVariant>)));
    }
}

void LsMediaMetadata::startUpdate()
{
    if (m_Player){
        connect(m_Player, SIGNAL(metadataChanged(QMap<QString,QVariant>)), this, SLOT(onMetadataChanged(QMap<QString,QVariant>)));
        m_Player->getCurrentMetadata();
    }
}

void LsMediaMetadata::onMetadataChanged(QMap<QString,QVariant> data)
{
    qDebug() << "Metadata changed";
    QString artist = data.value(SYSTEM_PLAYER_SONG_ARTIST).toString();
    if (artist.isEmpty())
        artist = tr("Unknown artist");

    QString title = data.value(SYSTEM_PLAYER_SONG_TITLE).toString();
    if (title.isEmpty())
        title = tr("Unknown title");

    if (artist != m_Artist || title != m_Title){
        m_Artist = artist;
        m_Title = title;
        update();
    }
}
