//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSDATETIME_H
#define LSDATETIME_H
#include <QTimer>
#include "lswidget.h"

class LsDateTime : public QObject, public LsWidget
{
    Q_OBJECT
public:
    LsDateTime(QString name="");

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
    void stopUpdate();
    void startUpdate();
    void applySettings();

private:
    QString m_TimeString;
    QString m_DateString;

    int m_Alignment;
    QTimer m_Timer;
    QTimer* m_StandbyTimer;
    QFont m_TimeFont;
    QFont m_DateFont;
    QColor m_TimeColor;
    QColor m_DateColor;

    QString m_DateFormat;
    QString m_TimeFormat;

private slots:
    void timerSlot();
};

#endif // LSDATETIME_H
