//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSBUTTON_H
#define LSBUTTON_H
#include "lswidget.h"

class LsButton : public QObject, public LsWidget
{
    Q_OBJECT
public:
    LsButton(QString name="");

    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                       QWidget *widget);

    virtual void clicked() = 0;
    virtual void pressed() {}
    virtual void released() {}

protected:
    QPixmap m_Bkg;
    QPixmap m_BkgPressed;
    bool m_Pressed;

    void mousePressEvent(QGraphicsSceneMouseEvent* event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent* event);
    void hoverLeaveEvent(QGraphicsSceneHoverEvent* event);

};

#endif // LSBUTTON_H
