//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSOPERATORNAME_H
#define LSOPERATORNAME_H
#include "lswidget.h"
class LsOperatorName : public QObject, public LsWidget
{
    Q_OBJECT
public:
    LsOperatorName(QString name="");

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
    void applySettings();
    void startUpdate();
    void stopUpdate();

private:
    QString m_OperatorName;
    int m_Alignment;
    QFont m_Font;
    QColor m_Color;
    QHash<QString, QString> m_Images;
    QPixmap m_Image;

    void setImage();
    void getOpetorName();

private slots:
#ifdef Q_WS_MAEMO_5
    void onOperatorNameChanged(QDBusMessage);
#endif
};

#endif // LSOPERATORNAME_H
