//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSMEDIAMETADATA_H
#define LSMEDIAMETADATA_H
#include "lswidget.h"
#include "backends/systemplayer.h"

class LsMediaMetadata : public QObject, public LsWidget
{
    Q_OBJECT
public:
    LsMediaMetadata(QString name="", SystemPlayer* player=0);

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);

    void applySettings();
    void stopUpdate();
    void startUpdate();

private:
    QMap<QString,QVariant> m_Metadata;
    SystemPlayer* m_Player;

    int m_Alignment;
    QFont m_TitleFont;
    QFont m_ArtistFont;
    QColor m_TitleColor;
    QColor m_ArtistColor;

private slots:
    void onMetadataChanged(QMap<QString,QVariant> data);
};

#endif // LSMEDIAMETADATA_H
