#ifndef LSMOVABLEIMAGE_H
#define LSMOVABLEIMAGE_H
#include "lsimage.h"
#include <QGraphicsSceneMouseEvent>
#include <QPropertyAnimation>
#define MIN_Z_VALUE -9999
#define MAX_Z_VALUE 9999

class LsMovableImage : public QObject, public LsImage
{
    Q_OBJECT
public:
    LsMovableImage(QString name="");
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);

    bool isPressed();
    void setImage(QPixmap);
    void setPressedImage(QPixmap);

private:
    bool m_IsPressed;
    QPointF m_MousePressPos;
    bool m_MoveStarted;
    QPointF m_PositionBeforeMove;
    qreal m_ZValue;

    QPixmap m_PressedImage;

    void setPressed(bool pressed);

protected:
    void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

signals:
    void pressedChanged(bool);
    void moveStarted();
    void moved(QPointF);
    void moveEnded();

};

#endif // LSMOVABLEIMAGE_H
