#include "lsmovableimage.h"

LsMovableImage::LsMovableImage(QString name) :
        LsImage(name.isEmpty() ? "Image": name)
{
    m_IsPressed = false;
    setFlag(QGraphicsItem::ItemIsMovable, true);
}

void LsMovableImage::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
           QWidget*)
{
    if (m_IsPressed && !m_PressedImage.isNull())
        painter->drawPixmap(0,0,m_PressedImage);
    else if (!m_Image.isNull())
        painter->drawPixmap(0,0,m_Image);
}

bool LsMovableImage::isPressed()
{
    return m_IsPressed;
}

void LsMovableImage::mouseMoveEvent(QGraphicsSceneMouseEvent* event)
{
    if (m_MoveStarted){
        qDebug() << "mouseMoveEvent:" << name() << event->pos();
        QPointF newPos(pos().x() + event->pos().x() - event->lastPos().x(),
                       pos().y() + event->pos().y() - event->lastPos().y());
        if (newPos.x() < 0)
            newPos.setX(0);
        else if (newPos.x() + size().width() > parentItem()->boundingRect().width())
            newPos.setX(parentItem()->boundingRect().width() - size().width());

        if (newPos.y() < 0)
            newPos.setY(0);
        else if (newPos.y() + size().height() > parentItem()->boundingRect().height())
            newPos.setY(parentItem()->boundingRect().height() - size().height());

        setPos(newPos);
        emit moved(newPos);
        if (!isUnderMouse()){
            mouseReleaseEvent(new QGraphicsSceneMouseEvent());
            return;
        }
    }
}

void LsMovableImage::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    qDebug() << "mousePressEvent:" << name() << mapToScene(event->pos());
    qDebug() << "  pos:" << event->pos();
    setPressed(true);

    if ((flags() & QGraphicsItem::ItemIsMovable) == QGraphicsItem::ItemIsMovable){
        qDebug() << "  move started";
        m_MousePressPos = event->pos();
        m_MoveStarted = true;
        m_PositionBeforeMove = scenePos();
        m_ZValue = zValue();
        setZValue(MAX_Z_VALUE);
        emit moveStarted();
    }
    update();
}

void LsMovableImage::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    qDebug() << "mouseReleaseEvent:" << name() << mapToScene(event->pos());
    int distance = 0;
    if (m_MoveStarted){
        qDebug() << "  move ended";
        m_MoveStarted = false;
        QPointF point = scenePos() - m_PositionBeforeMove;
        distance = point.manhattanLength();
        qDebug() << "  distance:" << distance;
        setZValue(m_ZValue);
        emit moveEnded();
    }
    if (isUnderMouse() && distance == 0){
        qDebug() << "clicked:" << name();
        //emit clicked();
    }

    setPressed(false);
    update();
}

void LsMovableImage::setPressed(bool pressed)
{
    if (m_IsPressed != pressed){
        m_IsPressed = pressed;
        qDebug() << "  PressedChanged:" << m_IsPressed;          
        emit pressedChanged(m_IsPressed);
    }
}

void LsMovableImage::setImage(QPixmap image)
{
    m_Image = image;
    setSize(m_Image.size());
}

void LsMovableImage::setPressedImage(QPixmap image)
{
    m_PressedImage = image;
}
