//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsmediaalbumart.h"

LsMediaAlbumArt::LsMediaAlbumArt(QString name, SystemPlayer* player) :
        LsWidget(name.isEmpty() ? "MediaAlbumArt": name)
{
    m_Player = player;
    applySettings();
}

void LsMediaAlbumArt::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
                            QWidget*)
{
    if (!m_AlbumArt.isNull()){
        painter->drawPixmap(0,0,m_AlbumArt);
    }
}

void LsMediaAlbumArt::applySettings()
{
    setSizeAndPosition(QSize(100, 100), QPoint(0, 0));

    m_NoCoverImage = getSetting("NoCoverImage", "/opt/qtlockscreen/default/no-album-art.png").toString();
    if (!m_NoCoverImage.isEmpty())
        m_AlbumArt = QPixmap(m_NoCoverImage).scaledToWidth(size().width());
}

void LsMediaAlbumArt::stopUpdate()
{
    if (m_Player){
        disconnect(m_Player, SIGNAL(metadataChanged(QMap<QString,QVariant>)), this, SLOT(onMetadataChanged(QMap<QString,QVariant>)));
    }
}

void LsMediaAlbumArt::startUpdate()
{
    if (m_Player){
        connect(m_Player, SIGNAL(metadataChanged(QMap<QString,QVariant>)), this, SLOT(onMetadataChanged(QMap<QString,QVariant>)));
        m_Player->getCurrentMetadata();
    }
}

void LsMediaAlbumArt::onMetadataChanged(QMap<QString,QVariant> data)
{
    QString path = data.value(SYSTEM_PLAYER_ALBUM_ART).toString();
    if (m_ArtPath != path){
        m_ArtPath = path;
        if (!path.isEmpty()){
            qDebug() << "Album art:" << path;
            m_AlbumArt = QPixmap(path).scaledToWidth(size().width());
        }else{
            if (!m_NoCoverImage.isEmpty())
                m_AlbumArt = QPixmap(m_NoCoverImage).scaledToWidth(size().width());
            else
                m_AlbumArt = QPixmap();
        }
        update();
    }
}

void LsMediaAlbumArt::onOrientationChanged()
{
    //Reload the albumart (the size can be different in portrait and landscape):
    QSize newSize = getSizeSetting(QSize(size().width(), size().height()));
    if (newSize.width() != size().width()) {
        if (!m_ArtPath.isEmpty()){
            qDebug() << "Reloading album art:" << m_ArtPath;
            m_AlbumArt = QPixmap(m_ArtPath).scaledToWidth(newSize.width());
        }else{
            if (!m_NoCoverImage.isEmpty())
                m_AlbumArt = QPixmap(m_NoCoverImage).scaledToWidth(newSize.width());
            else
                m_AlbumArt = QPixmap();
        }
        update();
    }
}
