//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsimage.h"

LsImage::LsImage(QString name) :
        LsWidget(name.isEmpty() ? "Image": name)
{
    applySettings();
}

void LsImage::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
                            QWidget*)
{
    if (!m_Image.isNull()){
        painter->drawPixmap(0,0,m_Image);
    }
}

void LsImage::applySettings()
{
    int alpha = getSetting("Alpha", "-1").toInt();

    m_Image = QPixmap(getSetting("Image", "").toString());
    if (alpha >= 0)
        m_Image = setAlpha(m_Image, alpha);
    setSizeAndPosition(QSize(100, 100), QPoint(0, 0));
}

QPixmap LsImage::setAlpha(QPixmap px, int val)
{
    QPixmap alpha = px;
    QPainter p(&alpha);
    p.fillRect(alpha.rect(), QColor(val, val, val));
    p.end();
    px.setAlphaChannel(alpha);
    return px;
}
