//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsdatetime.h"
#include <QDateTime>

LsDateTime::LsDateTime(QString name):
        LsWidget(name.isEmpty() ? "DateTime": name)
{
    applySettings();
    connect(&m_Timer, SIGNAL(timeout()), this, SLOT(timerSlot()));
    m_Timer.setInterval(500);
    m_Timer.setSingleShot(false);    
}

void LsDateTime::applySettings()
{
    m_Alignment = getAlignmentSetting("Alignment", Qt::AlignHCenter);
    QDateTime now = QDateTime::currentDateTime();

    m_TimeColor = getColorSetting("TimeColor", QColor(255,255,255));
    m_DateColor = getColorSetting("DateColor", QColor(255,255,255));

    m_DateFormat = getSetting("DateFormat", "dd/MM/yyyy").toString();
    m_TimeFormat = getSetting("TimeFormat", "hh:mm:ss").toString();
    if (m_TimeFormat.contains("s"))
        m_Timer.setInterval(500);
    else
        m_Timer.setInterval(2000);

    m_TimeFont = QFont();
    m_TimeFont.setPointSize(getSetting("TimeFontSize", 20).toInt());

    QFontMetrics fm(m_TimeFont);
    QSize size = fm.size(Qt::TextSingleLine, now.toString(m_TimeFormat));

    QRectF defSize(0,0, size.width(), size.height() + MINIMUM_TEXT_MARGIN);

    m_DateFont = QFont();
    m_DateFont.setPointSize(getSetting("DateFontSize", 15).toInt());
    fm = QFontMetrics(m_DateFont);
    size = fm.size(Qt::TextSingleLine, now.toString(m_DateFormat));
    defSize.setHeight(defSize.height() + size.height());
    if (size.width() > defSize.width())
        defSize.setWidth(size.width());

    setSizeAndPosition(QSize(defSize.width(), defSize.height()), QPoint(0, 0));
}

void LsDateTime::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
    QDateTime now = QDateTime::currentDateTime();

    painter->setFont(m_TimeFont);
    painter->setPen(m_TimeColor);
    painter->drawText(boundingRect(), Qt::AlignTop | m_Alignment | Qt::TextSingleLine, now.toString(m_TimeFormat));

    painter->setFont(m_DateFont);
    painter->setPen(m_DateColor);
    QRectF dateRect(boundingRect());
    QFontMetrics fm(m_TimeFont);
    dateRect.setTop(dateRect.top() + fm.size(Qt::TextSingleLine, now.toString(m_DateFormat)).height() + MINIMUM_TEXT_MARGIN);
    painter->drawText(dateRect, Qt::AlignTop | m_Alignment | Qt::TextSingleLine, now.toString(m_DateFormat));
}

void LsDateTime::timerSlot()
{
    update();
}

void LsDateTime::stopUpdate()
{
    m_Timer.stop();
}

void LsDateTime::startUpdate()
{
    if (!m_Timer.isActive()){
        timerSlot();
        m_Timer.start();
    }
}
